/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.container;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.ejb.TimerService;
import javax.naming.Context;
import javax.naming.NamingException;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.api.FactoryException;
import org.ow2.easybeans.api.bean.EasyBeansBean;
import org.ow2.easybeans.api.components.EZBComponentRegistry;
import org.ow2.easybeans.api.injection.EasyBeansInjectionException;
import org.ow2.easybeans.api.injection.ResourceInjector;
import org.ow2.easybeans.component.itf.TimerComponent;
import org.ow2.easybeans.naming.NamingManager;
import org.ow2.easybeans.naming.interceptors.ENCManager;
import org.ow2.easybeans.rpc.api.EJBRequest;
import org.ow2.easybeans.rpc.api.EJBResponse;
import org.ow2.easybeans.rpc.util.Hash;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.api.Pool;
import org.ow2.util.pool.api.PoolException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbsFactory<PoolType extends EasyBeansBean>
implements Factory<PoolType, Long> {
    private static Log logger = LogFactory.getLog(AbsFactory.class);
    private String className = null;
    private EZBContainer container = null;
    private Pool<PoolType, Long> pool = null;
    private Class<PoolType> beanClass = null;
    private Context javaContext = null;
    private static NamingManager namingManager = null;
    private List<ResourceInjector> injectors = null;
    private Map<Long, Method> hashes = null;
    private String id = null;
    private TimerService timerService = null;

    public AbsFactory(String className, EZBContainer container) throws FactoryException {
        this.className = className;
        this.container = container;
        this.id = String.valueOf(System.identityHashCode(this));
        Class<?> clazz = null;
        try {
            clazz = this.getContainer().getClassLoader().loadClass(this.getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new FactoryException("Cannot load the class for class name '" + this.getClassName() + "'", e);
        }
        this.setBeanClass(clazz);
        this.setHashes(Hash.hashClass(clazz));
        try {
            namingManager = NamingManager.getInstance();
        }
        catch (NamingException e) {
            throw new FactoryException("Cannot get instance of the naming manager", e);
        }
        this.injectors = container.getConfiguration().getInjectors();
        EZBComponentRegistry registry = container.getConfiguration().getEZBServer().getComponentManager().getComponentRegistry();
        List<TimerComponent> timerComponents = registry.getComponents(TimerComponent.class);
        if (timerComponents.size() > 0) {
            TimerComponent timerComponent = timerComponents.get(0);
            if (timerComponents.size() > 1) {
                logger.warn("There are {0} timer components running on this server. Only the first one will be used", new Integer(timerComponents.size()));
            }
            this.timerService = timerComponent.getTimerService(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(PoolType instance) {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getContainer().getClassLoader());
        try {
            instance.preDestroyEasyBeansLifeCycle();
        }
        catch (Exception e) {
            logger.error("Could not complete preDestroy method on instance", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        for (ResourceInjector injector : this.injectors) {
            try {
                injector.postEasyBeansDestroy((EasyBeansBean)instance);
            }
            catch (Throwable t) {
                logger.error("postEasyBeansDestroy() for {0} failed", injector.getClass().getName(), t);
            }
        }
    }

    protected void injectResources(PoolType instance) throws PoolException {
        for (ResourceInjector injector : this.injectors) {
            try {
                injector.preEasyBeansInject((EasyBeansBean)instance);
            }
            catch (Throwable t) {
                logger.error("preEasyBeansInject() for {0} failed", injector.getClass().getName(), t);
            }
        }
        try {
            instance.injectedByEasyBeans();
        }
        catch (EasyBeansInjectionException e) {
            throw new PoolException("Cannot inject resources in the created bean", e);
        }
        for (ResourceInjector injector : this.injectors) {
            try {
                injector.postEasyBeansInject((EasyBeansBean)instance);
            }
            catch (Throwable t) {
                logger.error("postEasyBeansInject() for {0} failed", injector.getClass().getName(), t);
            }
        }
    }

    protected Map<Long, Method> getHashes() {
        return this.hashes;
    }

    protected void setHashes(Map<Long, Method> hashes) {
        this.hashes = hashes;
    }

    @Override
    public Context getJavaContext() {
        return this.javaContext;
    }

    @Override
    public void setJavaContext(Context javaContext) {
        if (this.javaContext != null) {
            throw new IllegalStateException("The javaContext can only be set once. Already set !");
        }
        this.javaContext = javaContext;
        ENCManager.initContext(this, javaContext);
    }

    public Class<PoolType> getBeanClass() {
        return this.beanClass;
    }

    protected void setBeanClass(Class<PoolType> beanClass) {
        this.beanClass = beanClass;
    }

    protected void setPool(Pool<PoolType, Long> pool) {
        this.pool = pool;
    }

    @Override
    public EZBContainer getContainer() {
        return this.container;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    protected static NamingManager getNamingManager() {
        return namingManager;
    }

    @Override
    public Pool<PoolType, Long> getPool() {
        return this.pool;
    }

    @Override
    public abstract EJBResponse rpcInvoke(EJBRequest var1);

    @Override
    public void init() throws FactoryException {
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void stop() {
        ENCManager.removeContext(this);
    }

    @Override
    public TimerService getTimerService() {
        return this.timerService;
    }
}

