/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.container;

import java.util.ArrayList;
import java.util.List;
import org.ow2.easybeans.api.EZBContainerConfig;
import org.ow2.easybeans.api.EZBContainerLifeCycleCallback;
import org.ow2.easybeans.api.EZBServer;
import org.ow2.easybeans.api.injection.ResourceInjector;
import org.ow2.easybeans.api.naming.EZBNamingStrategy;
import org.ow2.easybeans.naming.strategy.DefaultNamingStrategy;
import org.ow2.easybeans.resolver.ContainerJNDIResolver;
import org.ow2.easybeans.resolver.api.EZBContainerJNDIResolver;
import org.ow2.util.archive.api.IArchive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JContainerConfig
implements EZBContainerConfig {
    private IArchive archive;
    private EZBServer embedded;
    private List<EZBContainerLifeCycleCallback> callbacks;
    private List<ResourceInjector> injectors;
    private EZBNamingStrategy namingStrategy = new DefaultNamingStrategy();
    private EZBContainerJNDIResolver containerJNDIResolver = null;

    public JContainerConfig(IArchive archive) {
        this.archive = archive;
        this.containerJNDIResolver = new ContainerJNDIResolver(archive);
        this.callbacks = new ArrayList<EZBContainerLifeCycleCallback>();
        this.injectors = new ArrayList<ResourceInjector>();
    }

    @Override
    public List<EZBContainerLifeCycleCallback> getCallbacks() {
        return this.callbacks;
    }

    @Override
    public void addCallback(EZBContainerLifeCycleCallback callback) {
        this.callbacks.add(callback);
    }

    @Override
    public IArchive getArchive() {
        return this.archive;
    }

    @Override
    public List<ResourceInjector> getInjectors() {
        return this.injectors;
    }

    @Override
    public void addInjectors(ResourceInjector injector) {
        this.injectors.add(injector);
    }

    @Override
    public EZBServer getEZBServer() {
        return this.embedded;
    }

    @Override
    public void setEZBServer(EZBServer embedded) {
        this.embedded = embedded;
    }

    @Override
    public EZBNamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    @Override
    public void setNamingStrategy(EZBNamingStrategy strategy) {
        this.namingStrategy = strategy;
    }

    @Override
    public EZBContainerJNDIResolver getContainerJNDIResolver() {
        return this.containerJNDIResolver;
    }

    @Override
    public void setContainerJNDIResolver(EZBContainerJNDIResolver containerJNDIResolver) {
        this.containerJNDIResolver = containerJNDIResolver;
    }
}

