/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.annotations.helper.bean;

import org.ow2.easybeans.asm.Type;
import org.ow2.easybeans.deployment.annotations.exceptions.ResolverException;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarArchiveMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarClassMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarMethodMetadata;
import org.ow2.util.scan.api.metadata.structures.JMethod;

public final class InheritanceMethodResolver {
    private static final String JAVA_LANG_OBJECT = Type.getInternalName(Object.class);

    private InheritanceMethodResolver() {
    }

    public static void resolve(EjbJarClassMetadata classAnnotationMetadata) throws ResolverException {
        InheritanceMethodResolver.addMethodMetadata(classAnnotationMetadata, classAnnotationMetadata);
    }

    private static void addMethodMetadata(EjbJarClassMetadata beanclassAnnotationMetadata, EjbJarClassMetadata visitingClassAnnotationMetadata) throws ResolverException {
        String superClass = visitingClassAnnotationMetadata.getSuperName();
        if (superClass != null) {
            if (superClass.equals(JAVA_LANG_OBJECT)) {
                return;
            }
            EjbJarArchiveMetadata ejbJarAnnotationMetadata = beanclassAnnotationMetadata.getEjbJarArchiveMetadata();
            EjbJarClassMetadata superClassMetadata = ejbJarAnnotationMetadata.getEjbJarClassMetadata(superClass);
            if (superClassMetadata == null) {
                throw new ResolverException("The class " + beanclassAnnotationMetadata + " extends the class " + superClass + "but this class seems to be outside of the ejb-jar");
            }
            for (EjbJarMethodMetadata methodAnnotationMetadata : superClassMetadata.getMethodMetadataCollection()) {
                JMethod method = methodAnnotationMetadata.getJMethod();
                EjbJarMethodMetadata beanMethod = (EjbJarMethodMetadata)beanclassAnnotationMetadata.getMethodMetadata(method);
                boolean overrided = true;
                boolean bl = overrided = (method.getAccess() & 2) != 2;
                if (beanMethod != null && (overrided || beanMethod == null || beanMethod.isInherited())) continue;
                EjbJarMethodMetadata clonedMethodAnnotationMetadata = (EjbJarMethodMetadata)methodAnnotationMetadata.clone();
                clonedMethodAnnotationMetadata.setClassMetadata(beanclassAnnotationMetadata);
                clonedMethodAnnotationMetadata.setInherited(true, superClassMetadata);
                beanclassAnnotationMetadata.addMethodMetadata(clonedMethodAnnotationMetadata);
                if (clonedMethodAnnotationMetadata.isPostConstruct()) {
                    beanclassAnnotationMetadata.addPostConstructMethodMetadata(clonedMethodAnnotationMetadata);
                }
                if (clonedMethodAnnotationMetadata.isPreDestroy()) {
                    beanclassAnnotationMetadata.addPreDestroyMethodMetadata(clonedMethodAnnotationMetadata);
                }
                if (clonedMethodAnnotationMetadata.isPostActivate()) {
                    beanclassAnnotationMetadata.addPostActivateMethodMetadata(clonedMethodAnnotationMetadata);
                }
                if (clonedMethodAnnotationMetadata.isPrePassivate()) {
                    beanclassAnnotationMetadata.addPrePassivateMethodMetadata(clonedMethodAnnotationMetadata);
                }
                if (!clonedMethodAnnotationMetadata.isAroundInvoke()) continue;
                beanclassAnnotationMetadata.addAroundInvokeMethodMetadata(clonedMethodAnnotationMetadata);
            }
            InheritanceMethodResolver.addMethodMetadata(beanclassAnnotationMetadata, superClassMetadata);
        }
    }
}

