/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.enhancer.injection;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.ejb.EJBContext;
import javax.ejb.MessageDrivenContext;
import javax.ejb.SessionContext;
import javax.ejb.TimerService;
import javax.jms.ConnectionFactory;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.jms.Topic;
import javax.jms.TopicConnectionFactory;
import javax.mail.Session;
import javax.mail.internet.MimePartDataSource;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import javax.transaction.UserTransaction;
import org.omg.CORBA.ORB;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.api.container.EZBEJBContext;
import org.ow2.easybeans.api.container.EZBMDBContext;
import org.ow2.easybeans.api.container.EZBSessionContext;
import org.ow2.easybeans.asm.ClassAdapter;
import org.ow2.easybeans.asm.ClassVisitor;
import org.ow2.easybeans.asm.MethodVisitor;
import org.ow2.easybeans.asm.Opcodes;
import org.ow2.easybeans.asm.Type;
import org.ow2.easybeans.deployment.annotations.impl.JAnnotationResource;
import org.ow2.easybeans.deployment.annotations.impl.JEjbEJB;
import org.ow2.easybeans.deployment.annotations.impl.JavaxPersistenceContext;
import org.ow2.easybeans.deployment.annotations.impl.JavaxPersistenceUnit;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarArchiveMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarClassMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarFieldMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarMethodMetadata;
import org.ow2.easybeans.enhancer.CommonClassGenerator;
import org.ow2.easybeans.enhancer.lib.MethodRenamer;
import org.ow2.easybeans.injection.JNDILookupHelper;
import org.ow2.easybeans.resolver.api.EZBContainerJNDIResolver;
import org.ow2.easybeans.resolver.api.EZBJNDIResolverException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.scan.api.metadata.structures.JMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectionClassAdapter
extends ClassAdapter
implements Opcodes {
    private static Log logger = LogFactory.getLog(InjectionClassAdapter.class);
    private EjbJarClassMetadata classAnnotationMetadata;
    private Map<String, Object> map = null;
    private boolean staticMode = false;
    private static final String EJBCONTEXT = EJBContext.class.getName();
    private static final String SESSION_CONTEXT = SessionContext.class.getName();
    private static final String MESSAGEDRIVEN_CONTEXT = MessageDrivenContext.class.getName();
    private static final String ORB_ITF = ORB.class.getName();
    private static final String DATASOURCE_ITF = DataSource.class.getName();
    private static final String USERTRANSACTION_ITF = UserTransaction.class.getName();
    private static final String QUEUE_ITF = Queue.class.getName();
    private static final String QUEUECONNECTIONFACTORY_ITF = QueueConnectionFactory.class.getName();
    private static final String CONNECTIONFACTORY_ITF = ConnectionFactory.class.getName();
    private static final String JCA_CONNECTIONFACTORY_ITF = javax.resource.cci.ConnectionFactory.class.getName();
    private static final String MAILSESSION_ITF = Session.class.getName();
    private static final String MIMEPARTDATASOURCE_ITF = MimePartDataSource.class.getName();
    private static final String TOPIC_ITF = Topic.class.getName();
    private static final String URL_ITF = URL.class.getName();
    private static final String TOPICCONNECTIONFACTORY_ITF = TopicConnectionFactory.class.getName();
    private static final String ENTITYMANAGER_ITF = EntityManager.class.getName();
    private static final String ENTITYMANAGERFACTORY_ITF = EntityManagerFactory.class.getName();
    private static final String TIMERSERVICE_ITF = TimerService.class.getName();
    private static final String EZB_EJBCONTEXT_DESC = Type.getDescriptor(EZBEJBContext.class);
    public static final String JAVA_LANG_OBJECT = "java/lang/Object";
    public static final String INJECTED_METHOD = "injectedByEasyBeans";
    public static final JMethod INJECTED_JMETHOD = new JMethod(1, MethodRenamer.encode("injectedByEasyBeans"), "()V", null, new String[]{"org/ow2/easybeans/api/injection/EasyBeansInjectionException"});
    public static final String[] INJECTED_METHODS = new String[]{"getEasyBeansContext", "setEasyBeansContext", "getEasyBeansFactory", "setEasyBeansFactory"};
    private static final int LENGTH = 3;
    private EZBContainerJNDIResolver containerJNDIResolver = null;

    public InjectionClassAdapter(EjbJarClassMetadata classAnnotationMetadata, ClassVisitor cv, Map<String, Object> map, boolean staticMode) {
        super(cv);
        this.classAnnotationMetadata = classAnnotationMetadata;
        this.map = map;
        this.staticMode = staticMode;
        this.containerJNDIResolver = (EZBContainerJNDIResolver)this.map.get(EZBContainerJNDIResolver.class.getName());
        if (this.containerJNDIResolver == null) {
            throw new IllegalStateException("No JNDI Resolver found under the key '" + EZBContainerJNDIResolver.class.getName() + "'.");
        }
    }

    @Override
    public void visitEnd() {
        super.visitEnd();
        this.addInjectedMethod();
        if (!this.classAnnotationMetadata.isBean()) {
            this.addDefaultMethods();
        }
    }

    private void addDefaultMethods() {
        CommonClassGenerator.addFieldGettersSetters(this.cv, this.classAnnotationMetadata.getClassName(), "easyBeansFactory", Factory.class);
        Class contextClass = null;
        contextClass = this.classAnnotationMetadata.isSession() ? EZBSessionContext.class : (this.classAnnotationMetadata.isMdb() ? EZBMDBContext.class : EZBEJBContext.class);
        CommonClassGenerator.addFieldGettersSetters(this.cv, this.classAnnotationMetadata.getClassName(), "easyBeansContext", contextClass);
    }

    private void addInjectedMethod() {
        EjbJarArchiveMetadata jarMetadata;
        EjbJarClassMetadata superMetadata;
        int access = 1;
        if (this.staticMode) {
            access += 8;
        }
        MethodVisitor mv = this.cv.visitMethod(access, INJECTED_METHOD, "()V", null, new String[]{"org/ow2/easybeans/api/injection/EasyBeansInjectionException"});
        mv.visitCode();
        String superNameClass = this.classAnnotationMetadata.getSuperName();
        if (superNameClass != null && !superNameClass.equals(JAVA_LANG_OBJECT) && (superMetadata = (jarMetadata = this.classAnnotationMetadata.getEjbJarArchiveMetadata()).getEjbJarClassMetadata(superNameClass)) != null) {
            if (!this.staticMode) {
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(183, superMetadata.getClassName(), INJECTED_METHOD, "()V");
            } else {
                mv.visitMethodInsn(184, superMetadata.getClassName(), INJECTED_METHOD, "()V");
            }
        }
        if (this.classAnnotationMetadata.isBean()) {
            String clNameManager = this.classAnnotationMetadata.getClassName() + "InterceptorManager";
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.classAnnotationMetadata.getClassName(), "easyBeansInterceptorManager", "L" + clNameManager + ";");
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.classAnnotationMetadata.getClassName(), "easyBeansContext", EZB_EJBCONTEXT_DESC);
            mv.visitMethodInsn(182, clNameManager, "setEasyBeansContext", "(" + EZB_EJBCONTEXT_DESC + ")V");
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.classAnnotationMetadata.getClassName(), "easyBeansInterceptorManager", "L" + clNameManager + ";");
            mv.visitMethodInsn(182, clNameManager, INJECTED_METHOD, "()V");
        }
        this.generateBodyInjectedMethod(mv);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void generateBodyInjectedMethod(MethodVisitor mv) {
        this.generateClassInjection(mv);
        this.generateAttributesInjection(mv);
        this.generateSettersInjection(mv);
    }

    private void generateClassInjection(MethodVisitor mv) {
        JAnnotationResource jAnnotationResource;
        List<JAnnotationResource> jAnnotationResources;
        JEjbEJB jEJB;
        List<JEjbEJB> jEjbs;
        List<JavaxPersistenceUnit> javaxPersistencePersistenceUnits;
        List<JavaxPersistenceContext> javaxPersistencePersistenceContexts = this.classAnnotationMetadata.getJavaxPersistencePersistenceContexts();
        if (javaxPersistencePersistenceContexts != null && javaxPersistencePersistenceContexts.size() > 0) {
            for (JavaxPersistenceContext javaxPersistenceContext : javaxPersistencePersistenceContexts) {
                this.bindClassPersistenceContext(javaxPersistenceContext, mv);
            }
        }
        if (this.classAnnotationMetadata.isPersistenceContext()) {
            this.bindClassPersistenceContext(this.classAnnotationMetadata.getJavaxPersistenceContext(), mv);
        }
        if ((javaxPersistencePersistenceUnits = this.classAnnotationMetadata.getJavaxPersistencePersistenceUnits()) != null && javaxPersistencePersistenceUnits.size() > 0) {
            for (JavaxPersistenceUnit javaxPersistenceUnit : javaxPersistencePersistenceUnits) {
                this.bindClassPersistenceUnit(javaxPersistenceUnit, mv);
            }
        }
        if (this.classAnnotationMetadata.isPersistenceUnit()) {
            this.bindClassPersistenceUnit(this.classAnnotationMetadata.getJavaxPersistenceUnit(), mv);
        }
        if ((jEjbs = this.classAnnotationMetadata.getJEjbEJBs()) != null && jEjbs.size() > 0) {
            for (JEjbEJB jEJB2 : jEjbs) {
                this.bindClassEJB(jEJB2, mv);
            }
        }
        if ((jEJB = this.classAnnotationMetadata.getJEjbEJB()) != null) {
            this.bindClassEJB(jEJB, mv);
        }
        if ((jAnnotationResources = this.classAnnotationMetadata.getJAnnotationResources()) != null && jAnnotationResources.size() > 0) {
            for (JAnnotationResource jAnnotationResource2 : jAnnotationResources) {
                this.bindResource(jAnnotationResource2, mv);
            }
        }
        if ((jAnnotationResource = this.classAnnotationMetadata.getJAnnotationResource()) != null) {
            this.bindResource(jAnnotationResource, mv);
        }
    }

    private void generateAttributesInjection(MethodVisitor mv) {
        for (EjbJarFieldMetadata fieldMetaData : this.classAnnotationMetadata.getFieldMetadataCollection()) {
            JAnnotationResource jAnnotationResource;
            JEjbEJB jEjb;
            Type typeInterface = Type.getType(fieldMetaData.getJField().getDescriptor());
            String itfName = typeInterface.getClassName();
            if (fieldMetaData.isPersistenceContext()) {
                this.validateAccessFieldAnnotation(fieldMetaData);
                if (!ENTITYMANAGER_ITF.equals(itfName)) {
                    throw new IllegalStateException("Trying to applied @PersistenceContext on an invalid field in the class '" + this.classAnnotationMetadata.getClassName() + "', field = " + fieldMetaData);
                }
                JavaxPersistenceContext javaxPersistenceContext = fieldMetaData.getJavaxPersistenceContext();
                logger.debug("Add injection for PersistenceContext on attribute {0} of class {1}", fieldMetaData.getFieldName(), this.classAnnotationMetadata.getClassName());
                mv.visitVarInsn(25, 0);
                this.addCallEntityManagerHelper(javaxPersistenceContext, mv);
                mv.visitFieldInsn(181, this.classAnnotationMetadata.getClassName(), fieldMetaData.getFieldName(), "Ljavax/persistence/EntityManager;");
                javaxPersistenceContext.setName(this.getJndiName(javaxPersistenceContext.getName(), fieldMetaData));
                this.bindClassPersistenceContext(javaxPersistenceContext, mv);
            }
            if (fieldMetaData.isPersistenceUnit()) {
                this.validateAccessFieldAnnotation(fieldMetaData);
                if (!ENTITYMANAGERFACTORY_ITF.equals(itfName)) {
                    throw new IllegalStateException("Trying to applied @PersistenceUnit on an invalid field in the class '" + this.classAnnotationMetadata.getClassName() + "', field = " + fieldMetaData);
                }
                logger.debug("Add injection for PersistenceUnit on attribute {0} of class {1}", fieldMetaData.getFieldName(), this.classAnnotationMetadata.getClassName());
                JavaxPersistenceUnit javaxPersistenceUnit = fieldMetaData.getJavaxPersistenceUnit();
                mv.visitVarInsn(25, 0);
                this.addCallEntityManagerFactoryHelper(javaxPersistenceUnit, mv);
                mv.visitFieldInsn(181, this.classAnnotationMetadata.getClassName(), fieldMetaData.getFieldName(), "Ljavax/persistence/EntityManagerFactory;");
                javaxPersistenceUnit.setName(this.getJndiName(javaxPersistenceUnit.getName(), fieldMetaData));
                this.bindClassPersistenceUnit(javaxPersistenceUnit, mv);
            }
            if ((jEjb = fieldMetaData.getJEjbEJB()) != null) {
                this.validateAccessFieldAnnotation(fieldMetaData);
                logger.debug("Add injection for EJB on attribute {0} of class {1}", fieldMetaData.getFieldName(), this.classAnnotationMetadata.getClassName());
                EZBContainerJNDIResolver containerJNDIResolver = (EZBContainerJNDIResolver)this.map.get(EZBContainerJNDIResolver.class.getName());
                String beanName = jEjb.getBeanName();
                String jndiName = null;
                String mappedName = jEjb.getMappedName();
                if (mappedName != null && !mappedName.equals("")) {
                    jndiName = mappedName;
                }
                if (jndiName == null) {
                    try {
                        jndiName = containerJNDIResolver.getUniqueName(itfName, beanName);
                    }
                    catch (EZBJNDIResolverException e) {
                        logger.error("No jndi name found on class {0} for interface {1} and beanName {2}", this.classAnnotationMetadata.getClassName(), itfName, beanName);
                    }
                }
                if (jndiName != null) {
                    logger.debug("Result of Asking jndi name on class {0} for interface {1} and beanName {2}. Result = {3}", this.classAnnotationMetadata.getClassName(), itfName, beanName, jndiName);
                    this.callAttributeJndi(jndiName, typeInterface, mv, fieldMetaData, this.classAnnotationMetadata.getClassName(), JNDILookupHelper.JndiType.REGISTRY);
                    this.callBindAttributeJndi(jEjb.getName(), jndiName, mv, fieldMetaData);
                }
            }
            if ((jAnnotationResource = fieldMetaData.getJAnnotationResource()) == null) continue;
            jAnnotationResource.setName(this.getJndiName(jAnnotationResource.getName(), fieldMetaData));
            this.updateAnnotationResource(jAnnotationResource);
            String mappedName = jAnnotationResource.getMappedName();
            this.validateAccessFieldAnnotation(fieldMetaData);
            if (SESSION_CONTEXT.equals(itfName)) {
                logger.debug("Add injection for @Resource on attribute {0} of class {1} for the type {2}", fieldMetaData.getFieldName(), this.classAnnotationMetadata.getClassName(), itfName);
                mv.visitVarInsn(25, 0);
                this.addCallGetEasyBeansContext(mv, "javax/ejb/SessionContext");
                mv.visitFieldInsn(181, this.classAnnotationMetadata.getClassName(), fieldMetaData.getFieldName(), "Ljavax/ejb/SessionContext;");
                jAnnotationResource.setType(SESSION_CONTEXT);
                this.bindResource(jAnnotationResource, mv);
                continue;
            }
            if (MESSAGEDRIVEN_CONTEXT.equals(itfName)) {
                logger.debug("Add injection for @Resource on attribute {0} of class {1} for the type {2}", fieldMetaData.getFieldName(), this.classAnnotationMetadata.getClassName(), itfName);
                mv.visitVarInsn(25, 0);
                this.addCallGetEasyBeansContext(mv, "javax/ejb/MessageDrivenContext");
                mv.visitFieldInsn(181, this.classAnnotationMetadata.getClassName(), fieldMetaData.getFieldName(), "Ljavax/ejb/MessageDrivenContext;");
                jAnnotationResource.setType(MESSAGEDRIVEN_CONTEXT);
                this.bindResource(jAnnotationResource, mv);
                continue;
            }
            if (EJBCONTEXT.equals(itfName)) {
                logger.debug("Add injection for @Resource on attribute {0} of class {1} for the type {2}", fieldMetaData.getFieldName(), this.classAnnotationMetadata.getClassName(), itfName);
                mv.visitVarInsn(25, 0);
                this.addCallGetEasyBeansContext(mv, "javax/ejb/EJBContext");
                mv.visitFieldInsn(181, this.classAnnotationMetadata.getClassName(), fieldMetaData.getFieldName(), "Ljavax/ejb/EJBContext;");
                jAnnotationResource.setType(EJBCONTEXT);
                this.bindResource(jAnnotationResource, mv);
                continue;
            }
            if (this.isEnvEntry(typeInterface)) {
                this.callAttributeJndi(jAnnotationResource.getName(), typeInterface, mv, fieldMetaData, this.classAnnotationMetadata.getClassName(), JNDILookupHelper.JndiType.JAVA_COMP_ENV);
                continue;
            }
            if (this.isJNDIResourceInjection(itfName)) {
                if (mappedName != null && !mappedName.equals("")) {
                    this.callAttributeJndi(mappedName, typeInterface, mv, fieldMetaData, this.classAnnotationMetadata.getClassName(), JNDILookupHelper.JndiType.REGISTRY);
                    this.callBindAttributeJndi(jAnnotationResource.getName(), mappedName, mv, fieldMetaData);
                    continue;
                }
                this.callAttributeJndi(jAnnotationResource.getName(), typeInterface, mv, fieldMetaData, this.classAnnotationMetadata.getClassName(), JNDILookupHelper.JndiType.JAVA_COMP_ENV);
                continue;
            }
            if (USERTRANSACTION_ITF.equals(itfName)) {
                this.callAttributeJndi("UserTransaction", typeInterface, mv, fieldMetaData, this.classAnnotationMetadata.getClassName(), JNDILookupHelper.JndiType.JAVA_COMP);
                this.callBindAttributeJndi(jAnnotationResource.getName(), "java:comp/UserTransaction", mv, fieldMetaData);
                continue;
            }
            if (URL_ITF.equals(itfName)) {
                this.callBindLookupURLRef(jAnnotationResource.getName(), mappedName, mv);
                this.callAttributeJndi(jAnnotationResource.getName(), typeInterface, mv, fieldMetaData, this.classAnnotationMetadata.getClassName(), JNDILookupHelper.JndiType.JAVA_COMP_ENV);
                continue;
            }
            if (TIMERSERVICE_ITF.equals(itfName)) {
                mv.visitVarInsn(25, 0);
                this.addCallGetEasyBeansContext(mv, null);
                mv.visitMethodInsn(185, Type.getInternalName(EZBEJBContext.class), "getTimerService", "()Ljavax/ejb/TimerService;");
                mv.visitFieldInsn(181, this.classAnnotationMetadata.getClassName(), fieldMetaData.getFieldName(), "Ljavax/ejb/TimerService;");
                this.callBindAttributeJndi(jAnnotationResource.getName(), "java:comp/TimerService", mv, fieldMetaData);
                continue;
            }
            if (!ORB_ITF.equals(itfName)) continue;
            if (!this.staticMode) {
                mv.visitVarInsn(25, 0);
            }
            mv.visitMethodInsn(184, "org/ow2/easybeans/injection/ORBInitHelper", "getORB", "()Lorg/omg/CORBA/ORB;");
            mv.visitFieldInsn(this.setField(), this.classAnnotationMetadata.getClassName(), fieldMetaData.getFieldName(), "Lorg/omg/CORBA/ORB;");
        }
    }

    private void updateAnnotationResource(JAnnotationResource jAnnotationResource) {
        List<Object> classResources = null;
        JAnnotationResource resClass = this.classAnnotationMetadata.getJAnnotationResource();
        if (resClass != null) {
            classResources = new ArrayList();
            classResources.add(resClass);
        } else {
            classResources = this.classAnnotationMetadata.getJAnnotationResources();
        }
        if (classResources != null) {
            for (JAnnotationResource jAnnotationResource2 : classResources) {
                if (!jAnnotationResource.getName().equals(jAnnotationResource2.getName())) continue;
                jAnnotationResource.setMappedName(jAnnotationResource2.getMappedName());
            }
        }
    }

    private void generateSettersInjection(MethodVisitor mv) {
        for (EjbJarMethodMetadata methodMetaData : this.classAnnotationMetadata.getMethodMetadataCollection()) {
            String itfName;
            Type typeInterface;
            JEjbEJB jEjb;
            if (methodMetaData.isInherited()) continue;
            JAnnotationResource jAnnotationResource = methodMetaData.getJAnnotationResource();
            if (jAnnotationResource != null) {
                Type typeInterface2 = this.validateSetterMethod(methodMetaData);
                String itfName2 = typeInterface2.getClassName();
                jAnnotationResource.setName(this.getJndiName(jAnnotationResource.getName(), methodMetaData));
                this.updateAnnotationResource(jAnnotationResource);
                String mappedName = jAnnotationResource.getMappedName();
                if (this.isEnvEntry(typeInterface2)) {
                    this.callMethodJndiEnv(jAnnotationResource.getName(), typeInterface2, mv, methodMetaData, this.classAnnotationMetadata.getClassName(), JNDILookupHelper.JndiType.JAVA_COMP_ENV);
                } else if (this.isJNDIResourceInjection(itfName2)) {
                    if (mappedName != null && !mappedName.equals("")) {
                        this.callMethodJndiEnv(mappedName, typeInterface2, mv, methodMetaData, this.classAnnotationMetadata.getClassName(), JNDILookupHelper.JndiType.REGISTRY);
                        this.callBindLookupJndiRef(jAnnotationResource.getName(), mappedName, mv);
                    } else {
                        logger.error("Cannot use the Resource annotation {0} as mappedName is null", jAnnotationResource);
                    }
                } else if (USERTRANSACTION_ITF.equals(itfName2)) {
                    this.callMethodJndiEnv("UserTransaction", typeInterface2, mv, methodMetaData, this.classAnnotationMetadata.getClassName(), JNDILookupHelper.JndiType.JAVA_COMP);
                    this.callBindLookupJndiRef(jAnnotationResource.getName(), "java:comp/UserTransaction", mv);
                } else if (TIMERSERVICE_ITF.equals(itfName2)) {
                    mv.visitVarInsn(25, 0);
                    this.addCallGetEasyBeansContext(mv, null);
                    mv.visitMethodInsn(185, "org/ow2/easybeans/api/container/EZBEJBContext", "getTimerService", "()Ljavax/ejb/TimerService;");
                    mv.visitMethodInsn(182, this.classAnnotationMetadata.getClassName(), methodMetaData.getMethodName(), "(Ljavax/ejb/TimerService;)V");
                    this.callBindLookupJndiRef(jAnnotationResource.getName(), "java:comp/TimerService", mv);
                } else if (SESSION_CONTEXT.equals(itfName2)) {
                    mv.visitVarInsn(25, 0);
                    this.addCallGetEasyBeansContext(mv, "javax/ejb/SessionContext");
                    mv.visitMethodInsn(182, this.classAnnotationMetadata.getClassName(), methodMetaData.getMethodName(), "(Ljavax/ejb/SessionContext;)V");
                    jAnnotationResource.setType(SESSION_CONTEXT);
                    this.bindResource(jAnnotationResource, mv);
                } else if (MESSAGEDRIVEN_CONTEXT.equals(itfName2)) {
                    mv.visitVarInsn(25, 0);
                    this.addCallGetEasyBeansContext(mv, "javax/ejb/MessageDrivenContext");
                    mv.visitMethodInsn(182, this.classAnnotationMetadata.getClassName(), methodMetaData.getMethodName(), "(Ljavax/ejb/MessageDrivenContext;)V");
                    jAnnotationResource.setType(MESSAGEDRIVEN_CONTEXT);
                    this.bindResource(jAnnotationResource, mv);
                } else if (EJBCONTEXT.equals(itfName2)) {
                    mv.visitVarInsn(25, 0);
                    this.addCallGetEasyBeansContext(mv, "javax/ejb/EJBContext");
                    mv.visitMethodInsn(182, this.classAnnotationMetadata.getClassName(), methodMetaData.getMethodName(), "(Ljavax/ejb/EJBContext;)V");
                    jAnnotationResource.setType(EJBCONTEXT);
                    this.bindResource(jAnnotationResource, mv);
                } else if (URL_ITF.equals(itfName2)) {
                    this.callBindLookupURLRef(jAnnotationResource.getName(), mappedName, mv);
                    this.callMethodJndiEnv(jAnnotationResource.getName(), typeInterface2, mv, methodMetaData, this.classAnnotationMetadata.getClassName(), JNDILookupHelper.JndiType.JAVA_COMP_ENV);
                }
            }
            if ((jEjb = methodMetaData.getJEjbEJB()) != null) {
                logger.debug("Add injection for EJB on method {0} of class {1}", methodMetaData.getMethodName(), this.classAnnotationMetadata.getClassName());
                typeInterface = this.validateSetterMethod(methodMetaData);
                itfName = typeInterface.getClassName();
                String beanName = jEjb.getBeanName();
                String jndiName = null;
                String mappedName = jEjb.getMappedName();
                if (mappedName != null && !mappedName.equals("")) {
                    jndiName = mappedName;
                }
                if (jndiName == null) {
                    try {
                        jndiName = this.containerJNDIResolver.getUniqueName(itfName, beanName);
                    }
                    catch (EZBJNDIResolverException e) {
                        logger.error("Cannot find JNDI Name on class {0} for interface {1} and beanName {2}. Result = {3}", this.classAnnotationMetadata.getClassName(), itfName, beanName);
                    }
                }
                if (jndiName != null) {
                    logger.debug("Asking jndi name on class {0} for interface {1} and beanName {2}. Result = {3}", this.classAnnotationMetadata.getClassName(), itfName, beanName, jndiName);
                    this.callMethodJndiEnv(jndiName, typeInterface, mv, methodMetaData, this.classAnnotationMetadata.getClassName(), JNDILookupHelper.JndiType.REGISTRY);
                    String encName = this.getJndiName(jEjb.getName(), methodMetaData);
                    this.callBindLookupJndiRef(encName, jndiName, mv);
                }
            }
            if (methodMetaData.isPersistenceContext()) {
                typeInterface = this.validateSetterMethod(methodMetaData);
                itfName = typeInterface.getClassName();
                if (!ENTITYMANAGER_ITF.equals(itfName)) {
                    throw new IllegalStateException("Trying to applied @PersistenceContext on an invalid method in the class '" + this.classAnnotationMetadata.getClassName() + "', method = " + methodMetaData);
                }
                logger.debug("Add injection for PersistenceContext on method {0} of class {1}", methodMetaData.getMethodName(), this.classAnnotationMetadata.getClassName());
                JavaxPersistenceContext javaxPersistenceContext = methodMetaData.getJavaxPersistenceContext();
                mv.visitVarInsn(25, 0);
                this.addCallEntityManagerHelper(javaxPersistenceContext, mv);
                mv.visitMethodInsn(182, this.classAnnotationMetadata.getClassName(), methodMetaData.getMethodName(), "(Ljavax/persistence/EntityManager;)V");
                javaxPersistenceContext.setName(this.getJndiName(javaxPersistenceContext.getName(), methodMetaData));
                this.bindClassPersistenceContext(javaxPersistenceContext, mv);
            }
            if (!methodMetaData.isPersistenceUnit()) continue;
            typeInterface = this.validateSetterMethod(methodMetaData);
            itfName = typeInterface.getClassName();
            if (!ENTITYMANAGERFACTORY_ITF.equals(itfName)) {
                throw new IllegalStateException("Trying to applied @PersistenceUnit on an invalid method in the class '" + this.classAnnotationMetadata.getClassName() + "', method = " + methodMetaData);
            }
            logger.debug("Add injection for PersistenceUnit on on method {0} of class {1}", methodMetaData.getMethodName(), this.classAnnotationMetadata.getClassName());
            JavaxPersistenceUnit javaxPersistenceUnit = methodMetaData.getJavaxPersistenceUnit();
            mv.visitVarInsn(25, 0);
            this.addCallEntityManagerFactoryHelper(javaxPersistenceUnit, mv);
            mv.visitMethodInsn(182, this.classAnnotationMetadata.getClassName(), methodMetaData.getMethodName(), "(Ljavax/persistence/EntityManagerFactory;)V");
            javaxPersistenceUnit.setName(this.getJndiName(javaxPersistenceUnit.getName(), methodMetaData));
            this.bindClassPersistenceUnit(javaxPersistenceUnit, mv);
        }
    }

    private Type validateSetterMethod(EjbJarMethodMetadata methodMetaData) {
        this.validateAccessMethodAnnotation(methodMetaData);
        JMethod jMethod = methodMetaData.getJMethod();
        if (!jMethod.getName().startsWith("set") || jMethod.getName().equalsIgnoreCase("set")) {
            throw new IllegalStateException("Method '" + jMethod + "' is invalid. Should be in the setter form setXXX().");
        }
        Type[] args = Type.getArgumentTypes(jMethod.getDescriptor());
        if (args.length != 1) {
            throw new IllegalStateException("Method args '" + Arrays.asList(args) + "' for method '" + jMethod + "' are invalid. Length should be of 1.");
        }
        return args[0];
    }

    private boolean isEnvEntry(Type type) {
        String itfName = type.getClassName();
        return String.class.getName().equals(itfName) || Boolean.TYPE.getName().equals(itfName) || Byte.TYPE.getName().equals(itfName) || Character.TYPE.getName().equals(itfName) || Double.TYPE.getName().equals(itfName) || Float.TYPE.getName().equals(itfName) || Integer.TYPE.getName().equals(itfName) || Long.TYPE.getName().equals(itfName) || Short.TYPE.getName().equals(itfName);
    }

    private void addCallGetEasyBeansContext(MethodVisitor mv, String castDesc) {
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, this.classAnnotationMetadata.getClassName(), "getEasyBeansContext", "()" + EZB_EJBCONTEXT_DESC);
        if (castDesc != null) {
            mv.visitTypeInsn(192, castDesc);
        }
    }

    private void addCallEntityManagerHelper(JavaxPersistenceContext javaxPersistenceContext, MethodVisitor mv) {
        this.addCallGetEasyBeansContext(mv, null);
        mv.visitLdcInsn(javaxPersistenceContext.getUnitName());
        mv.visitFieldInsn(178, "javax/persistence/PersistenceContextType", javaxPersistenceContext.getType().toString(), "Ljavax/persistence/PersistenceContextType;");
        mv.visitMethodInsn(184, "org/ow2/easybeans/injection/EntityManagerHelper", "getEntityManager", "(" + EZB_EJBCONTEXT_DESC + "Ljava/lang/String;Ljavax/persistence/PersistenceContextType;)" + "Ljavax/persistence/EntityManager;");
    }

    private void addCallEntityManagerFactoryHelper(JavaxPersistenceUnit javaxPersistenceUnit, MethodVisitor mv) {
        this.addCallGetEasyBeansContext(mv, null);
        mv.visitLdcInsn(javaxPersistenceUnit.getUnitName());
        mv.visitMethodInsn(184, "org/ow2/easybeans/injection/EntityManagerHelper", "getEntityManagerFactory", "(" + EZB_EJBCONTEXT_DESC + "Ljava/lang/String;)Ljavax/persistence/EntityManagerFactory;");
    }

    private void callJndi(String jndiName, Type type, MethodVisitor mv, String className, JNDILookupHelper.JndiType jndiType) {
        if (!this.staticMode) {
            mv.visitVarInsn(25, 0);
        }
        mv.visitLdcInsn(jndiName);
        String mName = "";
        switch (jndiType) {
            case JAVA_COMP: {
                mName = "getCompJndiName";
                break;
            }
            case JAVA_COMP_ENV: {
                mName = "getEnvJndiName";
                break;
            }
            case REGISTRY: {
                mName = "getJndiName";
                break;
            }
            default: {
                throw new IllegalStateException("invalid type");
            }
        }
        mv.visitMethodInsn(184, "org/ow2/easybeans/injection/JNDILookupHelper", mName, "(Ljava/lang/String;)Ljava/lang/Object;");
        CommonClassGenerator.transformObjectIntoPrimitive(type, mv);
    }

    private void callAttributeJndi(String jndiName, Type type, MethodVisitor mv, EjbJarFieldMetadata fieldMetaData, String className, JNDILookupHelper.JndiType jndiType) {
        logger.debug("Add injection for @Resource on attribute {0} of class {1} for the type {2}", fieldMetaData.getFieldName(), className, type.getClassName());
        String formattedJndiName = this.getJndiName(jndiName, fieldMetaData);
        this.callJndi(formattedJndiName, type, mv, className, jndiType);
        this.setField(mv, className, fieldMetaData, type);
    }

    private void setField(MethodVisitor mv, String className, EjbJarFieldMetadata fieldMetaData, Type type) {
        mv.visitFieldInsn(this.setField(), className, fieldMetaData.getFieldName(), type.getDescriptor());
    }

    private void callSetterMethod(MethodVisitor mv, String className, EjbJarMethodMetadata methodMetaData, Type type) {
        mv.visitMethodInsn(182, className, methodMetaData.getMethodName(), methodMetaData.getJMethod().getDescriptor());
    }

    private void callMethodJndiEnv(String jndiName, Type type, MethodVisitor mv, EjbJarMethodMetadata methodMetaData, String className, JNDILookupHelper.JndiType jndiType) {
        logger.debug("Add injection for @Resource on method {0} of class {1} for the type {2}", methodMetaData.getMethodName(), className, type.getClassName());
        String checkedJndiName = this.getJndiName(jndiName, methodMetaData);
        this.callJndi(checkedJndiName, type, mv, className, jndiType);
        this.callSetterMethod(mv, className, methodMetaData, type);
    }

    private String getJndiName(String jndiName, EjbJarFieldMetadata fieldAnnotationMetadata) {
        String newJndiName = jndiName;
        if (jndiName == null || "".equals(jndiName)) {
            logger.debug("Name property undefined.", new Object[0]);
            newJndiName = this.classAnnotationMetadata.getClassName().replace("/", ".") + "/" + fieldAnnotationMetadata.getFieldName();
            logger.debug("Getting environment's entry with default JNDI name: {0}", newJndiName);
        }
        return newJndiName;
    }

    private String getJndiName(String jndiName, EjbJarMethodMetadata methodMetaData) {
        String newJndiName = jndiName;
        if (jndiName == null || "".equals(jndiName)) {
            logger.debug("Property name not defined.", new Object[0]);
            StringBuilder propertyBuilder = new StringBuilder(methodMetaData.getMethodName());
            propertyBuilder.delete(0, 3);
            propertyBuilder.setCharAt(0, Character.toLowerCase(propertyBuilder.charAt(0)));
            propertyBuilder.insert(0, this.classAnnotationMetadata.getClassName().replace("/", ".") + "/");
            newJndiName = propertyBuilder.toString();
            logger.debug("Getting environment's entry with default JNDI name: {0}", newJndiName);
        }
        return newJndiName;
    }

    private void callBindAttributeJndi(String encName, String jndiName, MethodVisitor mv, EjbJarFieldMetadata fieldMetaData) {
        mv.visitLdcInsn(this.getJndiName(encName, fieldMetaData));
        mv.visitLdcInsn(jndiName);
        mv.visitMethodInsn(184, "org/ow2/easybeans/injection/JNDIBinderHelper", "bindLinkRefEnvJndiName", "(Ljava/lang/String;Ljava/lang/String;)V");
    }

    private void callBindLookupURLRef(String encName, String url, MethodVisitor mv) {
        mv.visitLdcInsn(encName);
        mv.visitLdcInsn(url);
        mv.visitMethodInsn(184, "org/ow2/easybeans/injection/JNDIBinderHelper", "bindLinkRefEnvURL", "(Ljava/lang/String;Ljava/lang/String;)V");
        logger.debug("Linking Object with URL '" + url + "' to ENC name '" + encName + "' for the class '" + this.classAnnotationMetadata.getClassName() + "'.", new Object[0]);
    }

    private void callBindLookupJndiRef(String encName, String jndiName, MethodVisitor mv) {
        mv.visitLdcInsn(encName);
        mv.visitLdcInsn(jndiName);
        mv.visitMethodInsn(184, "org/ow2/easybeans/injection/JNDIBinderHelper", "bindLinkRefEnvJndiName", "(Ljava/lang/String;Ljava/lang/String;)V");
        logger.debug("Linking Object with JNDI name '" + jndiName + "' to ENC name '" + encName + "' for the class '" + this.classAnnotationMetadata.getClassName() + "'.", new Object[0]);
    }

    private void bindClassEJB(JEjbEJB jEJB, MethodVisitor mv) {
        String encName = jEJB.getName();
        if (encName == null || "".equals(encName)) {
            throw new IllegalStateException("Error when analyzing @EJB annotation '" + jEJB + "' for the class '" + this.classAnnotationMetadata.getClassName() + "' : No name !");
        }
        String beanName = jEJB.getBeanName();
        String jndiName = null;
        if (jEJB.getMappedName() != null && jEJB.getMappedName().length() > 0) {
            jndiName = jEJB.getMappedName();
        } else {
            try {
                jndiName = this.containerJNDIResolver.getUniqueName(jEJB.getBeanInterface(), beanName);
            }
            catch (EZBJNDIResolverException e) {
                throw new IllegalStateException("No JNDI name found when analyzing @EJB annotation '" + jEJB + "' for the class '" + this.classAnnotationMetadata.getClassName() + "'.");
            }
        }
        this.callBindLookupJndiRef(encName, jndiName, mv);
    }

    private void bindResource(JAnnotationResource jAnnotationResource, MethodVisitor mv) {
        if (this.isJNDIResourceInjection(jAnnotationResource.getType()) || SESSION_CONTEXT.equals(jAnnotationResource.getType()) || EJBCONTEXT.equals(jAnnotationResource.getType()) || USERTRANSACTION_ITF.equals(jAnnotationResource.getType()) || URL_ITF.equals(jAnnotationResource.getType()) || TIMERSERVICE_ITF.equals(jAnnotationResource.getType())) {
            String encName = jAnnotationResource.getName();
            if (encName == null || "".equals(encName)) {
                logger.error("No encName for Annotation resource {0}.", jAnnotationResource);
                return;
            }
            String jndiName = null;
            jndiName = SESSION_CONTEXT.equals(jAnnotationResource.getType()) || EJBCONTEXT.equals(jAnnotationResource.getType()) ? "java:comp/EJBContext" : (USERTRANSACTION_ITF.equals(jAnnotationResource.getType()) ? "java:comp/UserTransaction" : (TIMERSERVICE_ITF.equals(jAnnotationResource.getType()) ? "java:comp/TimerService" : jAnnotationResource.getMappedName()));
            if (jndiName == null) {
                logger.error("MappedName for resource annotation {0} is null, no binding to ENC name {1}", jAnnotationResource, encName);
            } else if (URL_ITF.equals(jAnnotationResource.getType())) {
                this.callBindLookupURLRef(encName, jndiName, mv);
            } else {
                this.callBindLookupJndiRef(encName, jndiName, mv);
            }
        }
    }

    private void bindClassPersistenceContext(JavaxPersistenceContext javaxPersistenceContext, MethodVisitor mv) {
        String name = javaxPersistenceContext.getName();
        if (name == null || "".equals(name)) {
            logger.warn("PersistenceContext '" + javaxPersistenceContext + "' has an empty or null name, cannot bind it in ENC.", new Object[0]);
            return;
        }
        mv.visitLdcInsn(name);
        this.addCallEntityManagerHelper(javaxPersistenceContext, mv);
        mv.visitMethodInsn(184, "org/ow2/easybeans/injection/JNDIBinderHelper", "bindEnvJndiName", "(Ljava/lang/String;Ljava/lang/Object;)V");
    }

    private void bindClassPersistenceUnit(JavaxPersistenceUnit javaxPersistenceUnit, MethodVisitor mv) {
        String name = javaxPersistenceUnit.getName();
        if (name == null || "".equals(name)) {
            logger.warn("PersistenceUnit '" + javaxPersistenceUnit + "' has an empty or null name, cannot bind it in ENC.", new Object[0]);
            return;
        }
        mv.visitLdcInsn(name);
        this.addCallEntityManagerFactoryHelper(javaxPersistenceUnit, mv);
        mv.visitMethodInsn(184, "org/ow2/easybeans/injection/JNDIBinderHelper", "bindEnvJndiName", "(Ljava/lang/String;Ljava/lang/Object;)V");
    }

    private int setField() {
        int opCode = 181;
        if (this.staticMode) {
            opCode = 179;
        }
        return opCode;
    }

    private void validateAccessFieldAnnotation(EjbJarFieldMetadata field) {
        if (this.accessTest(field.getJField().getAccess(), 16)) {
            throw new IllegalStateException("The '" + field + "' attribute is a final attribute which is not compliant for dependency injection.");
        }
        if (!this.staticMode && this.accessTest(field.getJField().getAccess(), 8)) {
            throw new IllegalStateException("The '" + field + "' attribute is a static attribute which is not compliant for dependency injection.");
        }
    }

    private void validateAccessMethodAnnotation(EjbJarMethodMetadata methodData) {
        if (!this.staticMode && this.accessTest(methodData.getJMethod().getAccess(), 8)) {
            throw new IllegalStateException("The '" + methodData + "' method is a static attribute which is not compliant for dependency injection.");
        }
    }

    private boolean accessTest(int access, int checkedAccess) {
        return (access & checkedAccess) == checkedAccess;
    }

    private boolean isJNDIResourceInjection(String itfName) {
        return DATASOURCE_ITF.equals(itfName) || QUEUE_ITF.equals(itfName) || QUEUECONNECTIONFACTORY_ITF.equals(itfName) || TOPIC_ITF.equals(itfName) || CONNECTIONFACTORY_ITF.equals(itfName) || TOPICCONNECTIONFACTORY_ITF.equals(itfName) || MAILSESSION_ITF.equals(itfName) || MIMEPARTDATASOURCE_ITF.equals(itfName) || JCA_CONNECTIONFACTORY_ITF.equals(itfName);
    }
}

