/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.naming.interceptors;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.naming.Context;
import javax.naming.NamingException;
import org.ow2.easybeans.api.EasyBeansInvocationContext;
import org.ow2.easybeans.api.naming.NamingInterceptor;

public class TomcatENCInterceptor
implements NamingInterceptor {
    protected static final String TOMCAT_NAMING_CLASS = "org.apache.naming.ContextBindings";
    private static Method bindThreadMethod = null;
    private static Method getThreadNameMethod = null;
    private static Method unbindThreadMethod = null;
    private static Method bindContextMethod = null;
    private static Method unbindContextMethod = null;

    public TomcatENCInterceptor() {
        if (bindThreadMethod == null) {
            String errMsg = "Check that EasyBeans is embedded in Tomcat web server.";
            Class<?> namingClass = null;
            try {
                namingClass = Thread.currentThread().getContextClassLoader().loadClass(TOMCAT_NAMING_CLASS);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Cannot load the Tomcat naming class 'org.apache.naming.ContextBindings'. " + errMsg, e);
            }
            try {
                bindThreadMethod = namingClass.getMethod("bindThread", Object.class);
            }
            catch (SecurityException e) {
                throw new IllegalStateException("Cannot get bindThread() method on the Tomcat naming class 'org.apache.naming.ContextBindings'. " + errMsg, e);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Cannot get bindThread() method on the Tomcat naming class 'org.apache.naming.ContextBindings'. " + errMsg, e);
            }
            try {
                getThreadNameMethod = namingClass.getDeclaredMethod("getThreadName", new Class[0]);
            }
            catch (SecurityException e) {
                throw new IllegalStateException("Cannot get getThreadName() method on the Tomcat naming class 'org.apache.naming.ContextBindings'. " + errMsg, e);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Cannot get getThreadName() method on the Tomcat naming class 'org.apache.naming.ContextBindings'. " + errMsg, e);
            }
            getThreadNameMethod.setAccessible(true);
            try {
                unbindThreadMethod = namingClass.getMethod("unbindThread", Object.class);
            }
            catch (SecurityException e) {
                throw new IllegalStateException("Cannot get unbindThread() method on the Tomcat naming class 'org.apache.naming.ContextBindings'. " + errMsg, e);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Cannot get unbindThread() method on the Tomcat naming class 'org.apache.naming.ContextBindings'. " + errMsg, e);
            }
            try {
                bindContextMethod = namingClass.getMethod("bindContext", Object.class, Context.class);
            }
            catch (SecurityException e) {
                throw new IllegalStateException("Cannot get bindContext() method on the Tomcat naming class 'org.apache.naming.ContextBindings'. " + errMsg, e);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Cannot get bindContext() method on the Tomcat naming class 'org.apache.naming.ContextBindings'. " + errMsg, e);
            }
            try {
                unbindContextMethod = namingClass.getMethod("unbindContext", Object.class);
            }
            catch (SecurityException e) {
                throw new IllegalStateException("Cannot get unbindContext() method on the Tomcat naming class 'org.apache.naming.ContextBindings'. " + errMsg, e);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Cannot get unbindContext() method on the Tomcat naming class 'org.apache.naming.ContextBindings'. " + errMsg, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(EasyBeansInvocationContext invocationContext) throws Exception {
        Object object;
        block8: {
            block7: {
                Object name;
                block6: {
                    name = null;
                    try {
                        name = getThreadNameMethod.invoke((Object)null, new Object[0]);
                    }
                    catch (InvocationTargetException e) {
                        if (e.getTargetException() instanceof NamingException) break block6;
                        throw e;
                    }
                }
                bindThreadMethod.invoke(null, invocationContext.getFactory().getId());
                try {
                    object = invocationContext.proceed();
                    if (name == null) break block7;
                }
                catch (Throwable throwable) {
                    if (name != null) {
                        bindThreadMethod.invoke(null, name);
                    } else {
                        unbindThreadMethod.invoke(null, invocationContext.getFactory().getId());
                    }
                    throw throwable;
                }
                bindThreadMethod.invoke(null, name);
                break block8;
            }
            unbindThreadMethod.invoke(null, invocationContext.getFactory().getId());
        }
        return object;
    }

    public void initContext(String id, Context context) {
        try {
            bindContextMethod.invoke(null, id, context);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Cannot init the context for the given id '" + id + "'.", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot init the context for the given id '" + id + "'.", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Cannot init the context for the given id '" + id + "'.", e);
        }
    }

    public void removeContext(String id) {
        try {
            unbindContextMethod.invoke(null, id);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Cannot remove the context for the id '" + id + "'.", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot remove the context for the id '" + id + "'.", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Cannot remove the context for the id '" + id + "'.", e);
        }
    }
}

