/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.persistence.xml;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.ow2.easybeans.persistence.xml.JPersistenceUnitInfo;
import org.ow2.easybeans.persistence.xml.JPersistenceUnitInfoException;
import org.ow2.easybeans.persistence.xml.JPersistenceUnitInfoLoader;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public final class JPersistenceUnitInfoHelper {
    private static final String PERSISTENCE_CONFIG = "org/ow2/easybeans/persistence/conf/preconfigured-persistence-providers.xml";
    private static final String DEFAULT_PERSISTENCEPROVIDER_CONFIG = "org/ow2/easybeans/persistence/conf/default-persistence-provider.xml";
    public static final String DEFAULT_PERSISTENCE_PROVIDER = "org.ow2.easybeans.persistence.default.provider";
    private static Log logger = LogFactory.getLog(JPersistenceUnitInfoHelper.class);
    private static JPersistenceUnitInfo defaultPersistenceunitInfo = null;
    private static Map<String, JPersistenceUnitInfo> providersInfo = null;

    private JPersistenceUnitInfoHelper() {
    }

    public static JPersistenceUnitInfo[] getPersistenceUnitInfo(URL url) throws JPersistenceUnitInfoException {
        JPersistenceUnitInfo[] jPersistenceunitInfos;
        JPersistenceUnitInfoHelper.loadDefaultValues();
        for (JPersistenceUnitInfo jPersistenceunitInfo : jPersistenceunitInfos = JPersistenceUnitInfoLoader.loadPersistenceUnitInfoImpl(url)) {
            JPersistenceUnitInfo providerDefaultConf;
            String nonJtaDsName;
            String jtaDsName = jPersistenceunitInfo.getJtaDataSourceName();
            if (jtaDsName != null && !jtaDsName.equals("")) {
                DataSource ds = null;
                try {
                    ds = (DataSource)new InitialContext().lookup(jtaDsName);
                }
                catch (NamingException e) {
                    try {
                        logger.warn("Datasource named '" + jtaDsName + "' was not found, use instead the default jndi name jdbc_1", new Object[0]);
                        ds = (DataSource)new InitialContext().lookup("jdbc_1");
                    }
                    catch (NamingException ne) {
                        throw new JPersistenceUnitInfoException("Cannot get jta DataSource with the JNDI name '" + jtaDsName + "'.", ne);
                    }
                }
                jPersistenceunitInfo.setJtaDataSource(ds);
            }
            if ((nonJtaDsName = jPersistenceunitInfo.getNonJtaDataSourceName()) != null && !nonJtaDsName.equals("")) {
                DataSource ds = null;
                try {
                    ds = (DataSource)new InitialContext().lookup(nonJtaDsName);
                }
                catch (NamingException e) {
                    try {
                        logger.warn("Datasource named '" + nonJtaDsName + "' was not found, use instead the default jndi name jdbc_1", new Object[0]);
                        ds = (DataSource)new InitialContext().lookup("jdbc_1");
                    }
                    catch (NamingException ne) {
                        throw new JPersistenceUnitInfoException("Cannot get non jta DataSource with the JNDI name '" + nonJtaDsName + "'.", ne);
                    }
                }
                jPersistenceunitInfo.setNonJtaDataSource(ds);
            }
            if (jPersistenceunitInfo.getPersistenceProviderClassName() == null || jPersistenceunitInfo.getPersistenceProviderClassName().equals("")) {
                logger.info("No persistence provider was set, set to default value {0}.", defaultPersistenceunitInfo.getPersistenceProviderClassName());
                jPersistenceunitInfo.setPersistenceProviderClassName(defaultPersistenceunitInfo.getPersistenceProviderClassName());
            }
            if ((providerDefaultConf = providersInfo.get(jPersistenceunitInfo.getPersistenceProviderClassName())) == null) {
                logger.debug("No default configuration for the persistence provider {0}", jPersistenceunitInfo.getPersistenceProviderClassName());
                continue;
            }
            logger.debug("Found a default configuration for the persistence provider {0}", jPersistenceunitInfo.getPersistenceProviderClassName());
            Properties defaultProperties = providerDefaultConf.getProperties();
            Enumeration<?> providerPropertiesEnum = defaultProperties.propertyNames();
            while (providerPropertiesEnum.hasMoreElements()) {
                String key = (String)providerPropertiesEnum.nextElement();
                String value = defaultProperties.getProperty(key);
                if (jPersistenceunitInfo.getProperties().getProperty(key) != null) continue;
                jPersistenceunitInfo.getProperties().setProperty(key, value);
                logger.debug("Setting the property {0} with value {1}", key, value);
            }
        }
        return jPersistenceunitInfos;
    }

    private static synchronized void loadDefaultValues() throws JPersistenceUnitInfoException {
        if (defaultPersistenceunitInfo != null && providersInfo != null) {
            return;
        }
        defaultPersistenceunitInfo = new JPersistenceUnitInfo();
        providersInfo = new HashMap<String, JPersistenceUnitInfo>();
        ClassLoader currentCL = JPersistenceUnitInfo.class.getClassLoader();
        Enumeration<URL> urlsConfig = null;
        try {
            urlsConfig = currentCL.getResources(PERSISTENCE_CONFIG);
        }
        catch (IOException e) {
            throw new JPersistenceUnitInfoException("Cannot get resources with the name 'org/ow2/easybeans/persistence/conf/preconfigured-persistence-providers.xml' in the context classloader '" + currentCL + "'.");
        }
        LinkedList<URL> lstURLs = new LinkedList<URL>();
        while (urlsConfig.hasMoreElements()) {
            lstURLs.addFirst(urlsConfig.nextElement());
        }
        URL customizedConfig = currentCL.getResource(DEFAULT_PERSISTENCEPROVIDER_CONFIG);
        if (customizedConfig != null) {
            lstURLs.addLast(customizedConfig);
        }
        for (URL tmpURL : lstURLs) {
            JPersistenceUnitInfo[] jPersistenceunitInfos = JPersistenceUnitInfoLoader.loadPersistenceUnitInfoImpl(tmpURL);
            if (jPersistenceunitInfos.length != 1) {
                throw new JPersistenceUnitInfoException("Each default config file should have only one persistence unit '" + tmpURL + "'.");
            }
            JPersistenceUnitInfo pInfo = jPersistenceunitInfos[0];
            String persistenceProviderClassName = pInfo.getPersistenceProviderClassName();
            if (persistenceProviderClassName != null) {
                defaultPersistenceunitInfo.setPersistenceProviderClassName(persistenceProviderClassName);
            }
            Properties providersProperties = pInfo.getProperties();
            Enumeration<?> providerNames = providersProperties.propertyNames();
            while (providerNames.hasMoreElements()) {
                String providerName = (String)providerNames.nextElement();
                JPersistenceUnitInfo existingProviderInfo = providersInfo.get(providerName);
                if (existingProviderInfo == null) {
                    existingProviderInfo = new JPersistenceUnitInfo();
                    providersInfo.put(providerName, existingProviderInfo);
                }
                Enumeration<URL> urlsProviderConf = null;
                try {
                    urlsProviderConf = currentCL.getResources(providersProperties.getProperty(providerName));
                }
                catch (IOException e) {
                    throw new JPersistenceUnitInfoException("Cannot get resources with the name '" + providerName + "' in the context classloader '" + currentCL + "'.");
                }
                LinkedList<URL> reverseProviderConfURLs = new LinkedList<URL>();
                while (urlsProviderConf.hasMoreElements()) {
                    reverseProviderConfURLs.addFirst(urlsProviderConf.nextElement());
                }
                if (reverseProviderConfURLs.size() == 0) {
                    logger.warn("No default properties for persistence provider class named {0}", providerName);
                }
                for (URL providerURLConf : reverseProviderConfURLs) {
                    JPersistenceUnitInfo[] providerPersistenceunitInfos = JPersistenceUnitInfoLoader.loadPersistenceUnitInfoImpl(providerURLConf);
                    if (providerPersistenceunitInfos.length != 1) {
                        throw new JPersistenceUnitInfoException("Each default config file should have only one persistence unit '" + providerURLConf + "'.");
                    }
                    JPersistenceUnitInfo providerInfo = providerPersistenceunitInfos[0];
                    Properties providerProperties = providerInfo.getProperties();
                    Enumeration<?> providerPropertiesEnum = providerProperties.propertyNames();
                    while (providerPropertiesEnum.hasMoreElements()) {
                        String key = (String)providerPropertiesEnum.nextElement();
                        String value = providerProperties.getProperty(key);
                        existingProviderInfo.getProperties().setProperty(key, value);
                    }
                }
            }
        }
        String sysPropertyPersistenceProvider = System.getProperty(DEFAULT_PERSISTENCE_PROVIDER);
        if (sysPropertyPersistenceProvider != null) {
            logger.debug("System property overriding the persistence provider ''{0}'' with the new value ''{1}''", defaultPersistenceunitInfo.getPersistenceProviderClassName(), sysPropertyPersistenceProvider);
            defaultPersistenceunitInfo.setPersistenceProviderClassName(sysPropertyPersistenceProvider);
        }
        logger.info("Default persistence provider set to value {0}.", defaultPersistenceunitInfo.getPersistenceProviderClassName());
    }
}

