/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.security.propagation.context;

import org.ow2.easybeans.security.api.EZBSecurityContext;
import org.ow2.easybeans.security.api.EZBSecurityCurrent;
import org.ow2.easybeans.security.propagation.context.SecurityContext;

public class SecurityCurrent
implements EZBSecurityCurrent {
    private static InheritableThreadLocal<EZBSecurityContext> threadLocal;
    private static EZBSecurityContext globalContext;
    private static final EZBSecurityContext DEFAULT_CTX;
    private static EZBSecurityCurrent unique;

    public static EZBSecurityCurrent getCurrent() {
        if (unique == null) {
            unique = new SecurityCurrent();
        }
        return unique;
    }

    public void setSecurityContext(EZBSecurityContext securityContext) {
        threadLocal.set(securityContext);
    }

    public void setGlobalSecurityContext(EZBSecurityContext securityContext) {
        globalContext = securityContext;
    }

    public EZBSecurityContext getSecurityContext() {
        if (globalContext != null) {
            return globalContext;
        }
        if (threadLocal.get() != null) {
            return (EZBSecurityContext)threadLocal.get();
        }
        return DEFAULT_CTX;
    }

    public static void setSecurityCurrent(EZBSecurityCurrent current) {
        if (unique != null) {
            throw new IllegalStateException("Unable to set the unique instance. It is already set");
        }
        unique = current;
    }

    static {
        globalContext = null;
        DEFAULT_CTX = new SecurityContext();
        threadLocal = new InheritableThreadLocal();
        threadLocal.set(new SecurityContext());
        unique = null;
    }
}

