/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.server;

import java.io.File;
import java.net.URL;
import org.ow2.easybeans.server.Embedded;
import org.ow2.easybeans.server.EmbeddedConfigurator;
import org.ow2.easybeans.server.EmbeddedException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public final class EasyBeans {
    public static final String DEFAULT_XML_FILE = "org/ow2/easybeans/server/easybeans-default.xml";
    public static final String USER_XML_FILE = "easybeans.xml";
    private static final long SLEEP_TIME = 1000L;
    private static Log logger = LogFactory.getLog(EasyBeans.class);

    private EasyBeans() {
    }

    public static void main(String[] args) throws Exception {
        Embedded embedded = null;
        URL xmlConfigurationURL = Thread.currentThread().getContextClassLoader().getResource(USER_XML_FILE);
        if (xmlConfigurationURL == null) {
            xmlConfigurationURL = Thread.currentThread().getContextClassLoader().getResource(DEFAULT_XML_FILE);
            logger.info("No user-defined configuration file named ''{0}'' found in classpath. Using default settings from ''{1}''", USER_XML_FILE, xmlConfigurationURL);
        } else {
            logger.info("Using user-defined configuration file ''{0}''", xmlConfigurationURL);
        }
        try {
            embedded = EmbeddedConfigurator.create(xmlConfigurationURL);
        }
        catch (EmbeddedException e) {
            throw new Exception("Cannot create the embedded server", e);
        }
        Runtime.getRuntime().addShutdownHook(new ShutdownHook(embedded));
        embedded.getServerConfig().addDeployDirectory(new File("easybeans-deploy"));
        new ShutdownMonitorThread(embedded).start();
        embedded.start();
    }

    static class ShutdownHook
    extends Thread {
        private Embedded embedded = null;

        public ShutdownHook(Embedded embedded) {
            this.embedded = embedded;
        }

        public void run() {
            try {
                if (!this.embedded.isStopped()) {
                    this.embedded.stop();
                }
            }
            catch (EmbeddedException e) {
                System.err.println("Error while stopping embedded server");
                e.printStackTrace(System.err);
            }
        }
    }

    static class ShutdownMonitorThread
    extends Thread {
        private Embedded embedded = null;

        public ShutdownMonitorThread(Embedded embedded) {
            this.embedded = embedded;
        }

        public void run() {
            while (!this.embedded.isStopped()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    logger.debug("Error while sleeping", e);
                }
            }
            System.exit(0);
        }
    }
}

