/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.transaction.interceptors;

import javax.ejb.EJBException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.ow2.easybeans.api.EasyBeansInvocationContext;
import org.ow2.easybeans.api.bean.EasyBeansSFSB;
import org.ow2.easybeans.api.container.EZBSessionContext;
import org.ow2.easybeans.transaction.interceptors.AbsTransactionInterceptor;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class BMTStatefulTransactionInterceptor
extends AbsTransactionInterceptor {
    private Log logger = LogFactory.getLog(BMTStatefulTransactionInterceptor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Object intercept(EasyBeansInvocationContext invocationContext) throws Exception {
        EasyBeansSFSB statefulBean;
        EZBSessionContext sessionContext;
        Transaction beanTransaction;
        Transaction transaction;
        this.logger.debug("Calling BMT TX interceptor", new Object[0]);
        try {
            transaction = this.getTransactionManager().getTransaction();
        }
        catch (SystemException se) {
            throw new EJBException("Cannot get the current transaction on transaction manager.", se);
        }
        this.logger.debug("Transaction found = {0}", transaction);
        Transaction suspendedTransaction = null;
        if (transaction != null) {
            try {
                this.logger.debug("Suspending transaction {0}", transaction);
                suspendedTransaction = this.getTransactionManager().suspend();
            }
            catch (SystemException se) {
                throw new EJBException("Cannot call suspend() on the transaction manager.", se);
            }
        }
        if ((beanTransaction = (sessionContext = (EZBSessionContext)(statefulBean = (EasyBeansSFSB)invocationContext.getTarget()).getEasyBeansContext()).getBeanTransaction()) != null) {
            try {
                this.getTransactionManager().resume(beanTransaction);
            }
            catch (InvalidTransactionException ite) {
                throw new EJBException("Cannot call resume() on the previous bean transaction. There is an invalid transaction", ite);
            }
            catch (IllegalStateException ise) {
                throw new EJBException("Cannot call resume() on the previous bean transaction. There is another associated transaction", ise);
            }
            catch (SystemException se) {
                throw new EJBException("Cannot call resume() on the previous bean transaction. Unexpected error condition", se);
            }
        }
        Object se = invocationContext.proceed();
        Object var10_14 = null;
        Transaction transactionAfter = null;
        try {
            transactionAfter = this.getTransactionManager().getTransaction();
        }
        catch (SystemException se2) {
            throw new EJBException("Cannot get the current transaction on transaction manager.", se2);
        }
        if (transactionAfter != null) {
            int transactionStatus = transactionAfter.getStatus();
            if (transactionStatus != 3 && transactionStatus != 4) {
                sessionContext.setBeanTransaction(transactionAfter);
            } else {
                sessionContext.setBeanTransaction(null);
            }
        }
        if (suspendedTransaction != null) {
            this.logger.debug("Resuming transaction {0}", transaction);
            try {
                this.getTransactionManager().resume(suspendedTransaction);
            }
            catch (InvalidTransactionException ite) {
                throw new EJBException("Cannot call resume() on the given transaction. There is an invalid transaction", ite);
            }
            catch (IllegalStateException ise) {
                throw new EJBException("Cannot call resume() on the given transaction. There is another associated transaction", ise);
            }
            catch (SystemException se3) {
                throw new EJBException("Cannot call resume() on the given transaction. Unexpected error condition", se3);
            }
        }
        return se;
        catch (Exception e) {
            Object var8_35;
            try {
                this.handleBeanManagedException(invocationContext, e);
                var8_35 = null;
                Object var10_15 = null;
                transactionAfter = null;
            }
            catch (Throwable throwable) {
                Object var10_16 = null;
                transactionAfter = null;
                try {
                    transactionAfter = this.getTransactionManager().getTransaction();
                }
                catch (SystemException se2) {
                    throw new EJBException("Cannot get the current transaction on transaction manager.", se2);
                }
                if (transactionAfter != null) {
                    int transactionStatus = transactionAfter.getStatus();
                    if (transactionStatus != 3 && transactionStatus != 4) {
                        sessionContext.setBeanTransaction(transactionAfter);
                    } else {
                        sessionContext.setBeanTransaction(null);
                    }
                }
                if (suspendedTransaction != null) {
                    this.logger.debug("Resuming transaction {0}", transaction);
                    try {
                        this.getTransactionManager().resume(suspendedTransaction);
                    }
                    catch (InvalidTransactionException ite) {
                        throw new EJBException("Cannot call resume() on the given transaction. There is an invalid transaction", ite);
                    }
                    catch (IllegalStateException ise) {
                        throw new EJBException("Cannot call resume() on the given transaction. There is another associated transaction", ise);
                    }
                    catch (SystemException se3) {
                        throw new EJBException("Cannot call resume() on the given transaction. Unexpected error condition", se3);
                    }
                }
                throw throwable;
            }
            try {
                transactionAfter = this.getTransactionManager().getTransaction();
            }
            catch (SystemException se2) {
                throw new EJBException("Cannot get the current transaction on transaction manager.", se2);
            }
            if (transactionAfter != null) {
                int transactionStatus = transactionAfter.getStatus();
                if (transactionStatus != 3 && transactionStatus != 4) {
                    sessionContext.setBeanTransaction(transactionAfter);
                } else {
                    sessionContext.setBeanTransaction(null);
                }
            }
            if (suspendedTransaction != null) {
                this.logger.debug("Resuming transaction {0}", transaction);
                try {
                    this.getTransactionManager().resume(suspendedTransaction);
                }
                catch (InvalidTransactionException ite) {
                    throw new EJBException("Cannot call resume() on the given transaction. There is an invalid transaction", ite);
                }
                catch (IllegalStateException ise) {
                    throw new EJBException("Cannot call resume() on the given transaction. There is another associated transaction", ise);
                }
                catch (SystemException se3) {
                    throw new EJBException("Cannot call resume() on the given transaction. Unexpected error condition", se3);
                }
            }
            return var8_35;
        }
    }
}

