/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.util.xml;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SchemaEntityResolver
implements EntityResolver {
    private Map<String, String> schemasUrls = new HashMap<String, String>();

    public SchemaEntityResolver(String[] schemas) {
        URL url = null;
        for (int i = 0; i < schemas.length; ++i) {
            url = SchemaEntityResolver.class.getResource("/" + schemas[i]);
            if (url == null) {
                throw new IllegalStateException("'" + schemas[i] + "' was not found in the current classloader !");
            }
            String urlString = url.toString();
            String id = urlString.substring(urlString.lastIndexOf(47) + 1);
            this.schemasUrls.put(id, urlString);
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        String localPath = null;
        if (systemId != null && systemId.toLowerCase().endsWith(".xsd")) {
            String baseName = systemId.substring(systemId.lastIndexOf(47) + 1);
            localPath = this.schemasUrls.get(baseName);
        }
        if (localPath == null) {
            throw new SAXException("No XSD found for '" + systemId + "'.");
        }
        return new InputSource(localPath);
    }
}

