/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.archive.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Manifest;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.impl.AbsArchiveImpl;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.url.URLUtils;
import org.ow2.util.url.URLUtilsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryArchiveImpl
extends AbsArchiveImpl
implements IArchive {
    private static final String MANIFEST_PATH = "META-INF" + File.separator + "MANIFEST.MF";
    private Log logger = LogFactory.getLog(DirectoryArchiveImpl.class);
    private File directory = null;

    protected DirectoryArchiveImpl(File directory) {
        this.directory = directory;
        try {
            this.initMetadata();
        }
        catch (ArchiveException e) {
            this.logger.error("Cannot initialize metadata of file '" + directory + "'.", e);
        }
    }

    @Override
    public String getName() {
        return this.directory.getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initMetadata() throws ArchiveException {
        File manifestFile = new File(this.directory, MANIFEST_PATH);
        if (manifestFile.exists()) {
            Manifest manifest = null;
            FileInputStream is = null;
            try {
                try {
                    is = new FileInputStream(manifestFile);
                }
                catch (FileNotFoundException e) {
                    throw new ArchiveException("Cannot read the manifest file '" + manifestFile + "'", e);
                }
                try {
                    manifest = new Manifest(is);
                }
                catch (IOException e) {
                    throw new ArchiveException("Cannot read the manifest file '" + manifestFile + "'", e);
                }
            }
            finally {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException e) {
                        throw new ArchiveException("Cannot close the manifest file '" + manifestFile + "'", e);
                    }
                }
            }
            this.readManifest(manifest);
        }
    }

    private String encode(String resourceName) {
        String[] tokens = resourceName.split("/");
        StringBuilder sb = new StringBuilder();
        for (String token : tokens) {
            if (sb.length() > 0) {
                sb.append(File.separator);
            }
            sb.append(token);
        }
        return sb.toString();
    }

    @Override
    public boolean close() {
        return true;
    }

    @Override
    public URL getResource(String resourceName) throws ArchiveException {
        URL resourceURL = null;
        File f = new File(this.directory, this.encode(resourceName));
        try {
            if (f.exists()) {
                resourceURL = URLUtils.fileToURL2(f);
            }
        }
        catch (URLUtilsException e) {
            throw new ArchiveException("Invalid url", e);
        }
        return resourceURL;
    }

    @Override
    public Iterator<URL> getResources() throws ArchiveException {
        HashMap<String, URL> listResources = new HashMap<String, URL>();
        this.addFiles("", this.directory, listResources);
        return listResources.values().iterator();
    }

    private void addFiles(String name, File file, Map<String, URL> listResources) {
        block5: {
            block4: {
                if (!file.exists()) {
                    return;
                }
                if (!file.isDirectory()) break block4;
                File[] files = file.listFiles();
                if (files == null) break block5;
                for (File f : files) {
                    this.addFiles(name + f.getName() + "/", f, listResources);
                }
                break block5;
            }
            try {
                listResources.put(name + file.getName(), URLUtils.fileToURL2(file));
            }
            catch (URLUtilsException e) {
                throw new IllegalStateException("Invalid url", e);
            }
        }
    }

    @Override
    public Iterator<URL> getResources(String resourceName) throws ArchiveException {
        ArrayList<URL> listResources = new ArrayList<URL>();
        File f = new File(this.directory, this.encode(resourceName));
        if (f.exists()) {
            try {
                listResources.add(URLUtils.fileToURL2(f));
            }
            catch (URLUtilsException e) {
                throw new ArchiveException("Invalid url", e);
            }
        }
        return listResources.iterator();
    }

    @Override
    public URL getURL() throws ArchiveException {
        try {
            return URLUtils.fileToURL2(this.directory);
        }
        catch (URLUtilsException e) {
            throw new IllegalStateException("Invalid url", e);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof DirectoryArchiveImpl)) {
            return false;
        }
        DirectoryArchiveImpl other = (DirectoryArchiveImpl)o;
        return this.directory.equals(other.directory);
    }

    public int hashCode() {
        return this.directory.hashCode();
    }

    public String toString() {
        return this.getName();
    }

    public Iterator<String> getEntries() {
        HashMap<String, URL> listResources = new HashMap<String, URL>();
        this.addFiles("", this.directory, listResources);
        return listResources.keySet().iterator();
    }
}

