/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.archive.impl;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.impl.AbsArchiveImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLArchiveImpl
extends AbsArchiveImpl
implements IArchive {
    private Map<String, URL> entries;
    private URL url;

    public URLArchiveImpl(URL url) throws IOException {
        this.url = url;
        this.entries = new HashMap<String, URL>();
        JarInputStream jarInputStream = new JarInputStream(url.openStream());
        Manifest manifest = jarInputStream.getManifest();
        if (manifest != null) {
            this.readManifest(manifest);
        }
        ZipEntry zipEntry = jarInputStream.getNextEntry();
        while (zipEntry != null) {
            String name = zipEntry.getName();
            this.entries.put(name, new URL("jar:" + url + "!/" + name));
            zipEntry = jarInputStream.getNextEntry();
        }
        jarInputStream.close();
    }

    @Override
    public boolean close() {
        return true;
    }

    @Override
    public String getName() {
        return this.url.getPath();
    }

    @Override
    public URL getResource(String resourceName) {
        return this.entries.get(resourceName);
    }

    @Override
    public Iterator<URL> getResources() {
        return this.entries.values().iterator();
    }

    @Override
    public Iterator<URL> getResources(String resourceName) {
        LinkedList<URL> urlList = new LinkedList<URL>();
        URL url = this.entries.get(resourceName);
        if (url != null) {
            urlList.add(url);
        }
        return urlList.iterator();
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    public Iterator<String> getEntries() {
        return this.entries.keySet().iterator();
    }
}

