/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.scan.api;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.scan.api.DefaultArchiveHelper;
import org.ow2.util.scan.api.IArchiveHelper;
import org.ow2.util.scan.api.ScanException;
import org.ow2.util.scan.api.configurator.IArchiveConfigurator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ArchiveScanner {
    private List<URL> scannableURL;
    private List<IArchiveConfigurator> archiveConfigurators;
    private boolean scanEnded;
    private IArchiveHelper archiveHelper;

    public ArchiveScanner(IArchive archive) {
        this(new DefaultArchiveHelper(archive));
    }

    public ArchiveScanner(IArchiveHelper archiveHelper) {
        this.archiveHelper = archiveHelper;
        this.archiveConfigurators = new ArrayList<IArchiveConfigurator>();
        this.scanEnded = false;
    }

    private void prepareScan() throws ScanException {
        try {
            this.scannableURL = this.archiveHelper.listClassURL();
        }
        catch (ArchiveException e) {
            throw new ScanException("Error while analyzing archive '" + this.archiveHelper.getArchive().getName() + "'", e);
        }
    }

    public final void addArchiveConfigurator(IArchiveConfigurator archiveConfigurator) {
        this.archiveConfigurators.add(archiveConfigurator);
    }

    public final void removeArchiveConfigurator(IArchiveConfigurator archiveConfigurator) {
        this.archiveConfigurators.remove(archiveConfigurator);
    }

    protected abstract void doScan(URL var1) throws ScanException;

    public final void scanAll() throws ScanException {
        this.scanAll(true);
    }

    public final void scanAll(boolean closeArchive) throws ScanException {
        if (this.scanEnded) {
            throw new IllegalStateException("the scan is already terminated");
        }
        if (this.scannableURL == null) {
            this.prepareScan();
        }
        for (URL url : this.scannableURL) {
            this.doScan(url);
        }
        this.endScan(closeArchive);
    }

    public final void scanCollection(Collection<String> classNameCollection) throws ScanException {
        if (this.scanEnded) {
            throw new IllegalStateException("the scan is already terminated");
        }
        if (this.scannableURL == null) {
            this.prepareScan();
        }
        for (String className : classNameCollection) {
            try {
                URL url = this.archiveHelper.getClassURL(className);
                if (url == null || !this.scannableURL.contains(url)) continue;
                this.doScan(url);
                this.scannableURL.remove(url);
            }
            catch (ArchiveException e) {
                throw new ScanException("Error while analyzing archive '" + this.archiveHelper.getArchive().getName() + "'", e);
            }
        }
    }

    public final void endScan() {
        this.endScan(true);
    }

    public final void endScan(boolean closeArchive) {
        if (this.scanEnded) {
            throw new IllegalStateException("the scan is already terminated");
        }
        this.scannableURL.clear();
        if (closeArchive) {
            this.archiveHelper.getArchive().close();
        }
        this.scanEnded = true;
    }

    protected final IArchive getArchive() {
        return this.archiveHelper.getArchive();
    }

    protected final List<IArchiveConfigurator> getArchiveConfigurators() {
        return this.archiveConfigurators;
    }
}

