/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.scan.api.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ow2.util.scan.api.metadata.CommonMetadata;
import org.ow2.util.scan.api.metadata.IClassMetadata;
import org.ow2.util.scan.api.metadata.IFieldMetadata;
import org.ow2.util.scan.api.metadata.IMethodMetadata;
import org.ow2.util.scan.api.metadata.structures.JClass;
import org.ow2.util.scan.api.metadata.structures.JField;
import org.ow2.util.scan.api.metadata.structures.JMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassMetadata<C extends IClassMetadata<C, M, F>, M extends IMethodMetadata<C, M, F>, F extends IFieldMetadata<C, M, F>>
extends CommonMetadata
implements IClassMetadata<C, M, F> {
    private JClass jClass;
    private Map<JMethod, M> methodsAnnotationMetadata = null;
    private Map<JField, F> fieldsAnnotationMetadata = null;

    public ClassMetadata(JClass jClass) {
        this.jClass = jClass;
        this.methodsAnnotationMetadata = new HashMap<JMethod, M>();
        this.fieldsAnnotationMetadata = new HashMap<JField, F>();
    }

    @Override
    public final void addMethodMetadata(M methodAnnotationMetadata) {
        JMethod key = methodAnnotationMetadata.getJMethod();
        this.methodsAnnotationMetadata.put(key, methodAnnotationMetadata);
    }

    @Override
    public final M getMethodMetadata(JMethod jMethod) {
        return (M)((IMethodMetadata)this.methodsAnnotationMetadata.get(jMethod));
    }

    @Override
    public final List<M> searchMethodMetadata(String methodName) {
        if (methodName == null) {
            throw new IllegalArgumentException("Cannot search null methods");
        }
        ArrayList<IMethodMetadata> list = new ArrayList<IMethodMetadata>();
        for (IMethodMetadata method : this.methodsAnnotationMetadata.values()) {
            if (!methodName.equals(method.getJMethod().getName())) continue;
            list.add(method);
        }
        return list;
    }

    @Override
    public final List<F> searchFieldMetadata(String fieldName) {
        if (fieldName == null) {
            throw new IllegalArgumentException("Cannot search null fields");
        }
        ArrayList<IFieldMetadata> list = new ArrayList<IFieldMetadata>();
        for (IFieldMetadata field : this.fieldsAnnotationMetadata.values()) {
            if (!fieldName.equals(field.getJField().getName())) continue;
            list.add(field);
        }
        return list;
    }

    @Override
    public final Collection<M> getMethodMetadataCollection() {
        return this.methodsAnnotationMetadata.values();
    }

    @Override
    public final void addFieldMetadata(F fieldAnnotationMetadata) {
        JField key = fieldAnnotationMetadata.getJField();
        if (this.fieldsAnnotationMetadata.containsKey(key)) {
            throw new IllegalStateException();
        }
        this.fieldsAnnotationMetadata.put(key, fieldAnnotationMetadata);
    }

    @Override
    public final F getFieldMetadata(JField jField) {
        return (F)((IFieldMetadata)this.fieldsAnnotationMetadata.get(jField));
    }

    @Override
    public final Collection<F> getFieldMetadataCollection() {
        return this.fieldsAnnotationMetadata.values();
    }

    @Override
    public final JClass getJClass() {
        return this.jClass;
    }

    @Override
    public final void setJClass(JClass jClass) {
        this.jClass = jClass;
    }
}

