/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.scan.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.ow2.easybeans.asm.ClassReader;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.scan.api.ArchiveScanner;
import org.ow2.util.scan.api.IArchiveHelper;
import org.ow2.util.scan.api.ScanException;
import org.ow2.util.scan.impl.ScanClassVisitor;

public final class ArchiveScannerImpl
extends ArchiveScanner {
    public ArchiveScannerImpl(IArchive archive) {
        super(archive);
    }

    public ArchiveScannerImpl(IArchiveHelper archiveHelper) {
        super(archiveHelper);
    }

    protected void doScan(URL url) throws ScanException {
        InputStream is = null;
        try {
            URLConnection urlConnection = url.openConnection();
            urlConnection.setDefaultUseCaches(false);
            is = urlConnection.getInputStream();
            new ClassReader(is).accept(new ScanClassVisitor(this.getArchiveConfigurators()), 0);
        }
        catch (Exception ioe) {
            throw new ScanException("Error while analyzing file entry '" + url + "' in archive '" + this.getArchive().getName() + "'", ioe);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new ScanException("Error while closing input stream of the entry '" + url + "' in archive '" + this.getArchive().getName() + "'", e);
                }
            }
        }
    }
}

