/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.listeners;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.Trigger;

public class BroadcastSchedulerListener
implements SchedulerListener {
    private List listeners = new LinkedList();

    public BroadcastSchedulerListener() {
    }

    public BroadcastSchedulerListener(List listeners) {
        this();
        this.listeners.addAll(listeners);
    }

    public void addListener(SchedulerListener listener) {
        this.listeners.add(listener);
    }

    public boolean removeListener(SchedulerListener listener) {
        return this.listeners.remove(listener);
    }

    public List getListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public void jobScheduled(Trigger trigger) {
        Iterator itr = this.listeners.iterator();
        while (itr.hasNext()) {
            SchedulerListener l = (SchedulerListener)itr.next();
            l.jobScheduled(trigger);
        }
    }

    public void jobUnscheduled(String triggerName, String triggerGroup) {
        Iterator itr = this.listeners.iterator();
        while (itr.hasNext()) {
            SchedulerListener l = (SchedulerListener)itr.next();
            l.jobUnscheduled(triggerName, triggerGroup);
        }
    }

    public void triggerFinalized(Trigger trigger) {
        Iterator itr = this.listeners.iterator();
        while (itr.hasNext()) {
            SchedulerListener l = (SchedulerListener)itr.next();
            l.triggerFinalized(trigger);
        }
    }

    public void triggersPaused(String triggerName, String triggerGroup) {
        Iterator itr = this.listeners.iterator();
        while (itr.hasNext()) {
            SchedulerListener l = (SchedulerListener)itr.next();
            l.triggersPaused(triggerName, triggerGroup);
        }
    }

    public void triggersResumed(String triggerName, String triggerGroup) {
        Iterator itr = this.listeners.iterator();
        while (itr.hasNext()) {
            SchedulerListener l = (SchedulerListener)itr.next();
            l.triggersResumed(triggerName, triggerGroup);
        }
    }

    public void jobsPaused(String jobName, String jobGroup) {
        Iterator itr = this.listeners.iterator();
        while (itr.hasNext()) {
            SchedulerListener l = (SchedulerListener)itr.next();
            l.jobsPaused(jobName, jobGroup);
        }
    }

    public void jobsResumed(String jobName, String jobGroup) {
        Iterator itr = this.listeners.iterator();
        while (itr.hasNext()) {
            SchedulerListener l = (SchedulerListener)itr.next();
            l.jobsResumed(jobName, jobGroup);
        }
    }

    public void schedulerError(String msg, SchedulerException cause) {
        Iterator itr = this.listeners.iterator();
        while (itr.hasNext()) {
            SchedulerListener l = (SchedulerListener)itr.next();
            l.schedulerError(msg, cause);
        }
    }

    public void schedulerShutdown() {
        Iterator itr = this.listeners.iterator();
        while (itr.hasNext()) {
            SchedulerListener l = (SchedulerListener)itr.next();
            l.schedulerShutdown();
        }
    }
}

