/**
 * Copyright (c) 2010-2012 EBM WebSourcing, 2012-2018 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the New BSD License (3-clause license).
 *
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the New BSD License (3-clause license)
 * for more details.
 *
 * You should have received a copy of the New BSD License (3-clause license)
 * along with this program/library; If not, see http://directory.fsf.org/wiki/License:BSD_3Clause/
 * for the New BSD License (3-clause license).
 */
package com.ebmwebsourcing.easycommons.logger;

import java.lang.reflect.Array;
import java.util.Map;

public class BasicLogDataAppender implements LogDataAppender {

    @Override
    public boolean canAppend(Map<String,Object> logData, String dataKey) {
        assert logData != null;
        assert dataKey != null;
        return true;
    }

    @Override
    public void append(StringBuilder outBuffer, Map<String, Object> logData, String dataKey) {
        outBuffer.append(dataKey);
        Object dataValue = logData.get(dataKey);
        outBuffer.append(" = ");
        if (dataValue == null) {
            outBuffer.append("null");
        } else if (dataValue.getClass().isArray()) {
            outBuffer.append("'");
            int len = Array.getLength(dataValue);
            for (int i = 0; i < len; ++i) {
                outBuffer.append(String.valueOf(Array.get(dataValue, i)));
                if (i != len - 1)
                    outBuffer.append(", ");
            }
            outBuffer.append("'");
        } else {
            outBuffer.append("'").append(String.valueOf(dataValue)).append("'");
        }
    }
}
