/**
 * Copyright (c) 2010-2012 EBM WebSourcing, 2012-2018 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the New BSD License (3-clause license).
 *
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the New BSD License (3-clause license)
 * for more details.
 *
 * You should have received a copy of the New BSD License (3-clause license)
 * along with this program/library; If not, see http://directory.fsf.org/wiki/License:BSD_3Clause/
 * for the New BSD License (3-clause license).
 */
package com.ebmwebsourcing.easycommons.logger;

/**
 * Class allowing to define specific {@link java.util.logging.Level} in addition to JDK logging levels.
 * 
 * @author mjambert, aruffie
 * 
 */
public final class Level extends java.util.logging.Level {

    private static final long serialVersionUID = -5961140360420071107L;

    public static final java.util.logging.Level MONIT = new Level("MONIT", 600);

    public static final java.util.logging.Level MONIT_MSG = new Level("MONIT-MSG", 550);

    protected Level(String name, int value) {
        super(name, value);
    }

    /**
     * Allow to return all JDK logging {@link java.util.logging.Level} and specific logging {@link java.util.logging.Level}.
     * 
     * @return All {@link java.util.logging.Level} as an array in decreasing order.
     */
    public static final java.util.logging.Level[] getLevels() {
        return new java.util.logging.Level[] { OFF, SEVERE, WARNING, INFO, CONFIG, MONIT, MONIT_MSG, FINE,
                FINER, FINEST, ALL };
    }

    /**
     * This empty method must be called before any use of a custom Level. Custom
     * Level constructor add custom Levels to known Levels registered in
     * {@link java.util.logging.Level} class.
     */
    public static void initialize() {
    }

}
