/**
 * Copyright (c) 2010-2012 EBM WebSourcing, 2012-2018 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the New BSD License (3-clause license).
 *
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the New BSD License (3-clause license)
 * for more details.
 *
 * You should have received a copy of the New BSD License (3-clause license)
 * along with this program/library; If not, see http://directory.fsf.org/wiki/License:BSD_3Clause/
 * for the New BSD License (3-clause license).
 */
package com.ebmwebsourcing.easycommons.logger;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public abstract class LogData extends LinkedHashMap<String, Object> {

    public LogData() {
        super();
    }   
    
    protected void putData(String dataKey, Object dataValue) {
        super.put(dataKey, dataValue);
    }
   
    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(super.keySet());
    }
    
    @Override
    public Set<java.util.Map.Entry<String, Object>> entrySet() {
        return Collections.unmodifiableSet(super.entrySet());
    }
    
    @Override
    public Collection<Object> values() {
        return Collections.unmodifiableCollection(super.values());
    }
    
    @Override
    public Object put(String dataKey, Object dataValue) {
        throw new UnsupportedOperationException();
    }
    
   @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException();
    }
    
    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }
    
    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }
}
