/**
 * Copyright (c) 2010-2012 EBM WebSourcing, 2012-2018 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the New BSD License (3-clause license).
 *
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the New BSD License (3-clause license)
 * for more details.
 *
 * You should have received a copy of the New BSD License (3-clause license)
 * along with this program/library; If not, see http://directory.fsf.org/wiki/License:BSD_3Clause/
 * for the New BSD License (3-clause license).
 */
package com.ebmwebsourcing.easycommons.logger;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * @author aruffie
 * Class util which provide several helping methods
 */
public final class LoggerHelper {

    private LoggerHelper() {
    }
    
    /**
     * Get the level of a logger or the level owned by its parent.
     * @param logger a logger
     * @return the level of the logger or the level owned by its parent.
     */
    public static final Level getLevelOrParentLevel (final Logger logger) {
        assert logger != null;
        Level level = logger.getLevel();
        if(level == null) {
            assert logger.getParent() != null;
            level = getLevelOrParentLevel(logger.getParent());
        }
        return level;
    }
    
    /**
     * Get the handlers of a logger and the handlers owned by its parent if
     * it sends its output to its parent
     * @param logger a logger
     * @return the list of handlers of a logger and the handlers owned by its parent if
     * it sends its output to its parent
     */
    public static final List<Handler> getHandlersOrParentHanders(final Logger logger) {
        List<Handler> handlers = new ArrayList<Handler>(Arrays.asList(logger.getHandlers()));
        if(logger.getUseParentHandlers() && logger.getParent() != null) {
            handlers.addAll(getHandlersOrParentHanders(logger.getParent()));
        }
        return handlers;
    }
}
