/**
 * Copyright (c) 2010-2012 EBM WebSourcing, 2012-2018 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the New BSD License (3-clause license).
 *
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the New BSD License (3-clause license)
 * for more details.
 *
 * You should have received a copy of the New BSD License (3-clause license)
 * along with this program/library; If not, see http://directory.fsf.org/wiki/License:BSD_3Clause/
 * for the New BSD License (3-clause license).
 */
package com.ebmwebsourcing.easycommons.logger;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertSame;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

public class LevelTest {

    @Test
    public final void testGettingDefaultLevelsReturnJDKObjects() throws Exception {
        assertSame(java.util.logging.Level.OFF, Level.OFF);
        assertSame(java.util.logging.Level.SEVERE, Level.SEVERE);
        assertSame(java.util.logging.Level.WARNING, Level.WARNING);
        assertSame(java.util.logging.Level.INFO, Level.INFO);
        assertSame(java.util.logging.Level.CONFIG, Level.CONFIG);
        assertSame(java.util.logging.Level.FINE, Level.FINE);
        assertSame(java.util.logging.Level.FINER, Level.FINER);
        assertSame(java.util.logging.Level.FINEST, Level.FINEST);
        assertSame(java.util.logging.Level.ALL, Level.ALL);
    }

    @Test
    public final void testMONITLevelBetweenCONFIGandFINE() throws Exception {
        assertTrue(Level.CONFIG.intValue() > Level.MONIT.intValue());
        assertTrue(Level.MONIT.intValue() > Level.FINE.intValue());
    }
    
    @Test
    public final void testMONITMSGLevelBetweenMONITandFINE() throws Exception {
        assertTrue(Level.MONIT.intValue() > Level.MONIT_MSG.intValue());
        assertTrue(Level.MONIT_MSG.intValue() > Level.FINE.intValue());
    }

    @Test
    public final void testGettingMONITLevelSeveralTimesReturnSameObject() throws Exception {
        assertSame(Level.MONIT, Level.MONIT);
    }
    
    @Test
    public final void testGettingMONITMSGLevelSeveralTimesReturnSameObject() throws Exception {
        assertSame(Level.MONIT_MSG, Level.MONIT_MSG);
    }

    @Test
    public final void testCheckGetLevelsReturnOrder() throws Exception {
        final java.util.logging.Level[] levels = Level.getLevels();

        java.util.logging.Level previous = null;

        for (final java.util.logging.Level level : levels) {

            if (previous != null) {
                assertTrue("Level list isn't correctly ordered",
                        previous.intValue() > level.intValue());
            }

            previous = level;
        }
    }

    @Test
    public final void testParsingDefaultLevelsReturnJDKObjects() throws Exception {
        assertSame(java.util.logging.Level.OFF, Level.parse("OFF"));
        assertSame(java.util.logging.Level.SEVERE, Level.parse("SEVERE"));
        assertSame(java.util.logging.Level.WARNING, Level.parse("WARNING"));
        assertSame(java.util.logging.Level.INFO, Level.parse("INFO"));
        assertSame(java.util.logging.Level.CONFIG, Level.parse("CONFIG"));
        assertSame(java.util.logging.Level.FINE, Level.parse("FINE"));
        assertSame(java.util.logging.Level.FINER, Level.parse("FINER"));
        assertSame(java.util.logging.Level.FINEST, Level.parse("FINEST"));
        assertSame(java.util.logging.Level.ALL, Level.parse("ALL"));
    }
    
    /**
     * Here we use assertEquals and not assertSame because Level.KnowLevel stores
     * copies of the instances that were given to them by the constructor
     * of the current class (for security reasons).
     * @throws Exception
     */
    @Test
    public final void testParsingMONITLevels() throws Exception {
        assertEquals(Level.MONIT, Level.parse("MONIT"));
        assertEquals(Level.MONIT_MSG, Level.parse("MONIT-MSG"));
    }

    @Test
    public final void testJdkParsingMONITLevels() throws Exception {
        assertEquals(Level.MONIT, java.util.logging.Level.parse("MONIT"));
        assertEquals(Level.MONIT_MSG, java.util.logging.Level.parse("MONIT-MSG"));
    }
}
