/**
 * Copyright (c) 2010-2012 EBM WebSourcing, 2012-2018 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the New BSD License (3-clause license).
 *
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the New BSD License (3-clause license)
 * for more details.
 *
 * You should have received a copy of the New BSD License (3-clause license)
 * along with this program/library; If not, see http://directory.fsf.org/wiki/License:BSD_3Clause/
 * for the New BSD License (3-clause license).
 */
package com.ebmwebsourcing.easycommons.logger;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.Map.Entry;

import org.junit.Test;

import static org.junit.Assert.*;

public class LogDataTest {

    @Test
    public void testPutData() {
        LogData logData = new TestLogData();
        logData.putData("testKey", "testValue");
        assertEquals("testValue",logData.get("testKey"));
    }
    
    @Test(expected = UnsupportedOperationException.class)
    public void testKeySetUnmodifiable() {
        LogData logData = new TestLogData();
        Set<String> keySet = logData.keySet();
        keySet.remove("test");
    }
    
    @Test(expected = UnsupportedOperationException.class)
    public void testEntrySetUnmodifiable() {
        LogData logData = new TestLogData();
        logData.putData("test", "testKey");
        Set<Entry<String, Object>> entrySet = logData.entrySet();
        entrySet.remove(new AbstractMap.SimpleEntry<String, Object>("testKey", "testValue"));
    }

    @Test(expected = UnsupportedOperationException.class)
    public void testValuesUnmodifiable() {
        LogData logData = new TestLogData();
        Collection<Object> values = logData.values();
        values.remove(new Object());
    }

    @Test(expected = UnsupportedOperationException.class)
    public void testPutUnsupported() {
        LogData logData = new TestLogData();
        logData.put("test", "testKey");
    }
    
    @Test(expected = UnsupportedOperationException.class)
    public void testPutAllUnsupported() {
        LogData logData = new TestLogData();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("test", "testKey");
        logData.putAll(map);
    }
    
    @Test(expected = UnsupportedOperationException.class)
    public void testCloneUnsupported() {
        LogData logData = new TestLogData();
        logData.putData("test", "testKey");
        logData.clone();
    }
    
    @Test(expected = UnsupportedOperationException.class)
    public void testClearUnsupported() {
        LogData logData = new TestLogData();
        logData.putData("test", "testKey");
        logData.clear();
    }
    
    @Test(expected = UnsupportedOperationException.class)
    public void testRemoveUnsupported() {
        LogData logData = new TestLogData();
        logData.putData("test", "testKey");
        logData.remove("test");
    }
}
