/**
 * Copyright (c) 2010-2012 EBM WebSourcing, 2012-2018 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the New BSD License (3-clause license).
 *
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the New BSD License (3-clause license)
 * for more details.
 *
 * You should have received a copy of the New BSD License (3-clause license)
 * along with this program/library; If not, see http://directory.fsf.org/wiki/License:BSD_3Clause/
 * for the New BSD License (3-clause license).
 */
package com.ebmwebsourcing.easycommons.logger;

import java.util.logging.Level;
import java.util.logging.LogRecord;

public final class LogRecordHelper {

    private static final String TEST_LOGGER_NAME = "myLogger";

    private LogRecordHelper() {
    }

    /**
     * Create a log record with the logger name equals to myLogger. Set the
     * event time with the specified value.
     * 
     * @param level
     * @param msg
     * @param time
     * @return
     */
    public static final LogRecord newLogRecord(Level level, String msg, long time) {
        LogRecord logRecord = new LogRecord(level, msg);
        logRecord.setMillis(time);
        logRecord.setLoggerName(TEST_LOGGER_NAME);
        return logRecord;
    }

    public static final LogRecord newLogRecordWithException(java.util.logging.Level level,
            String msg, long time, Throwable t) {
        LogRecord logRecord = newLogRecord(level, msg, time);
        logRecord.setThrown(t);
        return logRecord;
    }
}
