/**
 * Copyright (c) 2010-2012 EBM WebSourcing, 2012-2018 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the New BSD License (3-clause license).
 *
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the New BSD License (3-clause license)
 * for more details.
 *
 * You should have received a copy of the New BSD License (3-clause license)
 * along with this program/library; If not, see http://directory.fsf.org/wiki/License:BSD_3Clause/
 * for the New BSD License (3-clause license).
 */
package com.ebmwebsourcing.easycommons.logger.handler;

import java.io.IOException;
import java.util.LinkedList;
import java.util.logging.FileHandler;
import java.util.logging.LogRecord;

/**
 * Stores logs in a list
 * 
 * @author Mathieu CARROLLE - EBM WebSourcing
 * 
 */
public class TestFileHandler extends FileHandler {

    private final LinkedList<String> logEntries;

    public TestFileHandler(String identifier) throws IOException {
        super("%t/" + identifier + "-%u", false);
        logEntries = new LinkedList<String>();
    }

    public TestFileHandler() throws IOException {
        this("log");
    }

    @Override
    public synchronized void publish(LogRecord record) {
        if (isLoggable(record)) {
            String entry = this.getFormatter().format(record);
            if (entry.endsWith("\n")) {
                entry = entry.substring(0, entry.length() - 1);
            }
            logEntries.add(entry);
        }
        super.publish(record);
    }

    @SuppressWarnings("unchecked")
    public LinkedList<String> getLogEntries() {
        return (LinkedList<String>) logEntries.clone();
    }

    @Override
    public void close() throws SecurityException {
        logEntries.clear();
        super.close();
    }
}
