/**
 * Copyright (c) 2010-2012 EBM WebSourcing, 2012-2018 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the New BSD License (3-clause license).
 *
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the New BSD License (3-clause license)
 * for more details.
 *
 * You should have received a copy of the New BSD License (3-clause license)
 * along with this program/library; If not, see http://directory.fsf.org/wiki/License:BSD_3Clause/
 * for the New BSD License (3-clause license).
 */
package com.ebmwebsourcing.easycommons.logger.handler;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import static org.junit.Assert.assertTrue;

import com.ebmwebsourcing.easycommons.logger.LogDataFormatter;

/**
 * 
 * @author Mathieu CARROLLE - EBM WebSourcing
 * 
 */
public class TestFileHandlerTest {

    private String LOG_RECORD_MESSAGE = "TestFileHandler test message ";

    private TestFileHandler handler;

    private static int count = 0;

    @Before
    public void createHandler() throws IOException {
        handler = new TestFileHandler("test_" + count++);
        handler.setFormatter(new LogDataFormatter());
    }

    @After
    public void afterTest() {
        if (handler != null) {
            handler.close();
        }
    }

    @Test
    public void testInfoHandlerWithInfoRecord() throws IOException {
        handler.setLevel(Level.INFO);
        publish(Level.INFO, 10);
        testLogEntries(handler.getLogEntries(), 10);
    }

    @Test
    public void testFinestHandlerWithMonitRecord() throws IOException {
        handler.setLevel(Level.FINEST);
        publish(com.ebmwebsourcing.easycommons.logger.Level.MONIT, 10);
        assertTrue(handler.getLogEntries().size() == 10);
        testLogEntries(handler.getLogEntries(), 10);
    }

    @Test
    public void testInfoHandlerWithFinestRecord() throws IOException {
        handler.setLevel(Level.INFO);
        publish(Level.FINEST, 10);
        assertTrue(handler.getLogEntries().size() == 0);
    }
    
    private void testLogEntries(List<String> logEntries, int expectedEntry) {
        assertTrue(logEntries.size() == expectedEntry);
        for (int i = 0; i < 10; i++) {
            assertTrue(logEntries.get(i).endsWith(LOG_RECORD_MESSAGE + i));
        }
    }

    private void publish(Level level, int nb) {
        for (int i = 0; i < nb; i++) {
            handler.publish(new LogRecord(level, LOG_RECORD_MESSAGE + i));
        }
    }
}
