/****************************************************************************
 * Copyright (c) 2010-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************/
 
package com.ebmwebsourcing.easycommons.thread;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;

import org.junit.Test;

/**
 * @author Olivier Fabre - EBM WebSourcing
 */
public class ConcurrentHashMapWithDefaultsTest {

    @Test
    public void testGetValueOrDefaultReturnsOwnValue() throws Exception {
        ConcurrentHashMapWithDefaults<String, Object> defaultMap = new ConcurrentHashMapWithDefaults<String, Object>();
        defaultMap.put("key1", new Integer(11));
        ConcurrentHashMapWithDefaults<String, Object> map = new ConcurrentHashMapWithDefaults<String, Object>(
                defaultMap);
        map.put("key1", new Integer(1));
        assertEquals(1, map.getValueOrDefault("key1"));
    }

    @Test
    public void testGetValueOrDefaultReturnsDefaultValue() {
        ConcurrentHashMapWithDefaults<String, Object> defaultMap = new ConcurrentHashMapWithDefaults<String, Object>();
        defaultMap.put("key1", new Integer(11));
        ConcurrentHashMapWithDefaults<String, Object> map = new ConcurrentHashMapWithDefaults<String, Object>(
                defaultMap);
        assertEquals(11, map.getValueOrDefault("key1"));
    }

    @Test
    public void testGetValueOrDefaultReturnsDefaultValueAfterRemoveOnOverridenValue() {
        ConcurrentHashMapWithDefaults<String, Object> defaultMap = new ConcurrentHashMapWithDefaults<String, Object>();
        defaultMap.put("key1", new Integer(11));
        ConcurrentHashMapWithDefaults<String, Object> map = new ConcurrentHashMapWithDefaults<String, Object>(
                defaultMap);
        map.put("key1", new Integer(1));
        assertEquals(1, map.getValueOrDefault("key1"));
        map.remove("key1");
        assertEquals(11, map.getValueOrDefault("key1"));
    }

    
    @Test
    public void testGetValueOrDefaultReturnsNullValue() {
        ConcurrentHashMapWithDefaults<String, Object> defaultMap = new ConcurrentHashMapWithDefaults<String, Object>();
        ConcurrentHashMapWithDefaults<String, Object> map = new ConcurrentHashMapWithDefaults<String, Object>(
                defaultMap);
        assertNull(map.getValueOrDefault("key1"));
    }

}
