/**
 * Copyright (c) 2010-2012 EBM WebSourcing, 2012-2016 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the New BSD License (3-clause license).
 *
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the New BSD License (3-clause license)
 * for more details.
 *
 * You should have received a copy of the New BSD License (3-clause license)
 * along with this program/library; If not, see http://directory.fsf.org/wiki/License:BSD_3Clause/
 * for the New BSD License (3-clause license).
 */
package com.ebmwebsourcing.easycommons.xml;

public final class QNameHelper {

    private QNameHelper() {
    }
    
    

    public static String getPrefix(final String name) {
        String res = null;
        if ((name != null)&&(name.indexOf(":") != -1)) {
            res = name.substring(0, name.indexOf(":"));
        }
        return res;
    }

    public static String getLocalPartWithoutPrefix(final String name) {
        String res = name;
        if (name.indexOf(':') != -1) {
            res = name.substring(name.indexOf(':') + 1, name.length());
        }
        return res;
    }
    
}
