/**
 * Copyright (c) 2010-2012 EBM WebSourcing, 2012-2016 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the New BSD License (3-clause license).
 *
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the New BSD License (3-clause license)
 * for more details.
 *
 * You should have received a copy of the New BSD License (3-clause license)
 * along with this program/library; If not, see http://directory.fsf.org/wiki/License:BSD_3Clause/
 * for the New BSD License (3-clause license).
 */
package com.ebmwebsourcing.easycommons.registry.concurrency;

import java.util.concurrent.atomic.AtomicInteger;

import com.ebmwebsourcing.easycommons.registry.KeyNotFoundException;
import com.ebmwebsourcing.easycommons.registry.ResourceRegistry;

/**
 * @author ofabre
 * 
 */
public class ConcurrentUnregisterTestTask extends AbstractResourceRegistryConcurrencyTestTask {

    public ConcurrentUnregisterTestTask(AtomicInteger counter, ResourceRegistry<Object> resourceRegistry, String keyToUseForRegisteredObject) {
        super(counter, resourceRegistry,keyToUseForRegisteredObject);
    }

    @Override
    public void run() {
        try {
            resourceRegistry.unregister(keyToUseForRegisteredObject);
            counter.decrementAndGet();
        } catch (KeyNotFoundException e) {
            counter.incrementAndGet();
        }
    }

}
