/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.tooling.java2wsdl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.ejb.Remote;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import org.ow2.easywsdl.schema.SchemaFactory;
import org.ow2.easywsdl.schema.api.ComplexContent;
import org.ow2.easywsdl.schema.api.ComplexType;
import org.ow2.easywsdl.schema.api.Element;
import org.ow2.easywsdl.schema.api.Extension;
import org.ow2.easywsdl.schema.api.Schema;
import org.ow2.easywsdl.schema.api.Sequence;
import org.ow2.easywsdl.schema.api.absItf.AbsItfComplexContent;
import org.ow2.easywsdl.schema.api.absItf.AbsItfElement;
import org.ow2.easywsdl.schema.api.absItf.AbsItfExtension;
import org.ow2.easywsdl.schema.api.absItf.AbsItfSequence;
import org.ow2.easywsdl.schema.api.absItf.AbsItfType;
import org.ow2.easywsdl.tooling.java2wsdl.WSDLGenerationContext;
import org.ow2.easywsdl.wsdl.WSDLFactory;
import org.ow2.easywsdl.wsdl.api.Binding;
import org.ow2.easywsdl.wsdl.api.BindingOperation;
import org.ow2.easywsdl.wsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.Endpoint;
import org.ow2.easywsdl.wsdl.api.Fault;
import org.ow2.easywsdl.wsdl.api.Input;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.Operation;
import org.ow2.easywsdl.wsdl.api.Output;
import org.ow2.easywsdl.wsdl.api.Service;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfBinding;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfEndpoint;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfFault;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfInput;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfInterfaceType;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfOperation;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfOutput;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfService;

public class JavaToEasyWSDL {
    private static String XML_SCHEMA_PREFIX = "http://www.w3.org/2001/XMLSchema";
    private boolean verbose;
    private String namespace;
    private String serviceName;
    private String webServiceName;
    private boolean polymorph;
    private List<String> polymorphClasses;
    private boolean isCurrentClassPOJO = false;

    public JavaToEasyWSDL(boolean verbose) {
        this.verbose = verbose;
    }

    public WSDLGenerationContext generateWSDL(List<Class<?>> classes, boolean polymorph, List<String> polymorphClasses) throws WSDLException {
        this.polymorph = polymorph;
        this.polymorphClasses = polymorphClasses;
        WSDLGenerationContext res = new WSDLGenerationContext();
        Description desc = WSDLFactory.newInstance().newDescription(AbsItfDescription.WSDLVersionConstants.WSDL11);
        res.setDescription(desc);
        for (Class<?> clazz : classes) {
            WebService webServiceAnnotation;
            Method[] methods;
            this.generateGlobalInfo(clazz, res);
            InterfaceType itf = this.generateInterface(clazz, res);
            for (Method method : methods = clazz.getDeclaredMethods()) {
                if (this.isCurrentClassPOJO && method.getAnnotation(WebMethod.class) == null) continue;
                this.generateOperation(res, itf, method);
            }
            Service service = (Service)desc.createService();
            service.setQName(this.cQName(this.serviceName));
            desc.addService((AbsItfService)service);
            Endpoint ep = (Endpoint)service.createEndpoint();
            String endpointName = this.webServiceName + "Port";
            if (clazz.getAnnotation(WebService.class) != null && !"".equals((webServiceAnnotation = clazz.getAnnotation(WebService.class)).portName())) {
                endpointName = webServiceAnnotation.portName();
            }
            ep.setName(endpointName);
            ep.setAddress("MODIFY_ADDRESS");
            service.addEndpoint((AbsItfEndpoint)ep);
            Binding binding = (Binding)desc.createDefaultSoapBinding(this.webServiceName + "Binding", (AbsItfEndpoint)ep, (AbsItfInterfaceType)itf);
            List ops = binding.getBindingOperations();
            for (BindingOperation op : ops) {
                op.setSoapAction("");
            }
            desc.addBinding((AbsItfBinding)binding);
        }
        for (String className : this.polymorphClasses) {
            try {
                Class<?> clazz = Class.forName(className);
                this.generateComplexTypeSchema(res, clazz);
            }
            catch (ClassNotFoundException e) {
                System.err.println("Warning : Additional polymorph class not found for name " + className);
            }
        }
        return res;
    }

    private void generateGlobalInfo(Class<?> clazz, WSDLGenerationContext context) throws WSDLException {
        this.debug("Generating global info for class : " + clazz);
        this.isCurrentClassPOJO = clazz.getAnnotation(Remote.class) != null;
        this.namespace = this.createNamespace(clazz.getPackage());
        this.serviceName = clazz.getSimpleName();
        this.webServiceName = this.serviceName + "PortType";
        Description desc = context.getDescription();
        if (clazz.getAnnotation(WebService.class) != null) {
            WebService webServiceAnnotation = clazz.getAnnotation(WebService.class);
            if (!"".equals(webServiceAnnotation.targetNamespace())) {
                this.namespace = webServiceAnnotation.targetNamespace();
            }
            if (!"".equals(webServiceAnnotation.serviceName())) {
                this.serviceName = webServiceAnnotation.serviceName();
            }
            if (!"".equals(webServiceAnnotation.name())) {
                this.webServiceName = webServiceAnnotation.name();
            }
        }
        desc.setTargetNamespace(this.namespace);
        desc.setQName(this.cQName(this.serviceName));
    }

    private void generateOperation(WSDLGenerationContext context, InterfaceType itf, Method method) throws WSDLException {
        this.debug("******** Processing Method : " + method);
        Operation operation = (Operation)itf.createOperation();
        String opName = method.getName();
        operation.setQName(this.cQName(opName));
        itf.addOperation((AbsItfOperation)operation);
        this.generateInputParameter(context, method, operation);
        this.generateOutputParameter(context, method, operation);
        this.generateFault(context, method, operation);
    }

    private void generateFault(WSDLGenerationContext context, Method method, Operation operation) throws WSDLException {
        Type[] exceptionsType = method.getGenericExceptionTypes();
        if (exceptionsType.length > 0) {
            this.debug("    Fault Type:--");
            for (int i = 0; i < exceptionsType.length; ++i) {
                Type type = exceptionsType[i];
                if (this.isInstanceOf(type, (Type)((Object)RuntimeException.class)) || !this.isInstanceOf(type, (Type)((Object)Exception.class))) continue;
                this.debug("                    --  " + type);
                Class clazz = (Class)type;
                Fault fault = (Fault)operation.createFault();
                operation.addFault((AbsItfFault)fault);
                String namespace = context.getDescription().getTargetNamespace();
                String faultName = clazz.getSimpleName();
                fault.setName(faultName);
                fault.setMessageName(new QName(context.getDescription().getTargetNamespace(), faultName));
                Schema schema = context.getSchema(namespace);
                Element elem = (Element)schema.createElement();
                elem.setQName(new QName(context.getDescription().getTargetNamespace(), faultName + "Element"));
                schema.addElement((AbsItfElement)elem);
                fault.setElement(elem);
                ComplexType cType = (ComplexType)schema.createComplexType();
                schema.addType((AbsItfType)cType);
                elem.setType((AbsItfType)cType);
                cType.setQName(new QName(namespace, faultName + "Type"));
                Sequence sequence = (Sequence)cType.createSequence();
                cType.setSequence((AbsItfSequence)sequence);
                Field[] fields = clazz.getDeclaredFields();
                this.generateExceptionFields(context, sequence, namespace, fields);
                for (clazz = clazz.getSuperclass(); Exception.class != clazz; clazz = clazz.getSuperclass()) {
                    fields = clazz.getDeclaredFields();
                    this.generateExceptionFields(context, sequence, namespace, fields);
                }
            }
        }
    }

    private void generateExceptionFields(WSDLGenerationContext context, Sequence sequence, String namespace, Field[] fields) {
        for (Field field : fields) {
            Element elem = (Element)sequence.createElement();
            elem.setQName(new QName(namespace, field.getName()));
            elem.setType((AbsItfType)this.getXMLSchemaType(context, field.getType()));
            sequence.addElement((AbsItfElement)elem);
        }
    }

    private void generateOutputParameter(WSDLGenerationContext context, Method method, Operation operation) throws WSDLException {
        Type returnType = method.getGenericReturnType();
        this.debug("    Return Type:------  " + returnType);
        String methodName = method.getName();
        String paramName = methodName + "Response";
        Output output = (Output)operation.createOutput();
        output.setName(paramName);
        output.setMessageName(this.cQName(paramName + "Message"));
        operation.setOutput((AbsItfOutput)output);
        QName elemName = this.cQName(paramName);
        Schema schema = context.getSchema(this.namespace);
        Element elem = (Element)schema.createElement();
        elem.setQName(elemName);
        schema.addElement((AbsItfElement)elem);
        output.setElement(elem);
        ComplexType elemType = (ComplexType)schema.createComplexType();
        elemType.setQName(this.cQName(elemName.getLocalPart()));
        elem.setType((AbsItfType)elemType);
        schema.addType((AbsItfType)elemType);
        Sequence sequence = (Sequence)elemType.createSequence();
        elemType.setSequence((AbsItfSequence)sequence);
        if (!returnType.equals(Void.TYPE)) {
            Element elem2 = (Element)sequence.createElement();
            String returnName = "return";
            WebResult webReturn = method.getAnnotation(WebResult.class);
            if (webReturn != null) {
                returnName = webReturn.name();
            }
            elem2.setQName(this.cQName(returnName));
            if (returnType instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)returnType;
                if (this.isInstanceOf(pType.getRawType(), (Type)((Object)List.class))) {
                    elem2.setType((AbsItfType)this.getXMLSchemaType(context, pType.getActualTypeArguments()[0]));
                    elem2.setMaxOccurs("unbounded");
                }
            } else if (((Class)returnType).isArray()) {
                elem2.setType((AbsItfType)this.getXMLSchemaType(context, ((Class)returnType).getComponentType()));
                elem2.setMaxOccurs("unbounded");
            } else {
                elem2.setType((AbsItfType)this.getXMLSchemaType(context, returnType));
            }
            sequence.addElement((AbsItfElement)elem2);
        }
    }

    private void generateInputParameter(WSDLGenerationContext context, Method method, Operation operation) throws WSDLException {
        this.debug("Generating input parameters for : " + method.getName());
        Input input = (Input)operation.createInput();
        String methodName = method.getName();
        String paramName = methodName + "Request";
        input.setName(paramName);
        input.setMessageName(this.cQName(methodName + "Request" + "Message"));
        operation.setInput((AbsItfInput)input);
        Schema schema = context.getSchema(this.namespace);
        Element elem = (Element)schema.createElement();
        elem.setQName(this.cQName(methodName));
        schema.addElement((AbsItfElement)elem);
        input.setElement(elem);
        ComplexType elemType = (ComplexType)schema.createComplexType();
        elemType.setQName(this.cQName(methodName));
        elem.setType((AbsItfType)elemType);
        schema.addType((AbsItfType)elemType);
        Type[] paramsType = method.getGenericParameterTypes();
        Annotation[][] methodParamsAnnotations = method.getParameterAnnotations();
        if (paramsType.length > 0) {
            Sequence sequence = (Sequence)elemType.createSequence();
            elemType.setSequence((AbsItfSequence)sequence);
            for (int i = 0; i < paramsType.length; ++i) {
                Type type = paramsType[i];
                Element elem2 = (Element)sequence.createElement();
                if (methodParamsAnnotations[i].length != 0) {
                    Annotation[] paramAnnotations = methodParamsAnnotations[i];
                    for (int j = 0; j < paramAnnotations.length; ++j) {
                        if (!(paramAnnotations[j] instanceof WebParam) || ((WebParam)paramAnnotations[j]).name() == null) continue;
                        elem2.setQName(this.cQName(((WebParam)paramAnnotations[j]).name()));
                    }
                } else {
                    elem2.setQName(this.cQName("arg" + i));
                }
                if (type instanceof ParameterizedType) {
                    ParameterizedType pType = (ParameterizedType)type;
                    if (this.isInstanceOf(pType.getRawType(), (Type)((Object)List.class))) {
                        elem2.setType((AbsItfType)this.getXMLSchemaType(context, pType.getActualTypeArguments()[0]));
                        elem2.setMaxOccurs("unbounded");
                    }
                } else if (((Class)type).isArray()) {
                    elem2.setType((AbsItfType)this.getXMLSchemaType(context, ((Class)type).getComponentType()));
                    elem2.setMaxOccurs("unbounded");
                } else {
                    elem2.setType((AbsItfType)this.getXMLSchemaType(context, type));
                }
                elem2.setMinOccurs(0);
                sequence.addElement((AbsItfElement)elem2);
            }
        }
    }

    private InterfaceType generateInterface(Class<?> clazz, WSDLGenerationContext context) {
        this.debug("Generating port type for class : " + clazz);
        InterfaceType itf = (InterfaceType)context.getDescription().createInterface();
        itf.setQName(new QName(this.namespace, this.webServiceName));
        context.getDescription().addInterface((AbsItfInterfaceType)itf);
        return itf;
    }

    private org.ow2.easywsdl.schema.api.Type getXMLSchemaType(WSDLGenerationContext context, Type type) {
        org.ow2.easywsdl.schema.api.Type simpleType = this.getSchemaSimpleType(type);
        if (simpleType != null) {
            return simpleType;
        }
        return this.generateComplexTypeSchema(context, type);
    }

    private org.ow2.easywsdl.schema.api.Type generateComplexTypeSchema(WSDLGenerationContext context, Type type) {
        if (!(type instanceof TypeVariable || type instanceof GenericArrayType || type instanceof WildcardType)) {
            if (type instanceof ParameterizedType) {
                return this.generateParametrizedType(context, type);
            }
            Class clazz = (Class)type;
            if (clazz.isArray()) {
                return this.generateCollectionComplexType(context, context.getDescription().getTargetNamespace(), "Array", clazz.getComponentType());
            }
            return this.generateComplexType(context, clazz, new ArrayList());
        }
        this.unknownType(type);
        return SchemaFactory.getDefaultSchema().getType(new QName(XML_SCHEMA_PREFIX, "anyType"));
    }

    private org.ow2.easywsdl.schema.api.Type generateParametrizedType(WSDLGenerationContext context, Type type) {
        ParameterizedType tParameterizedType = (ParameterizedType)type;
        Type tRawType = tParameterizedType.getRawType();
        if (tRawType instanceof TypeVariable || tRawType instanceof GenericArrayType || tRawType instanceof WildcardType || tRawType instanceof ParameterizedType) {
            this.unknownType(type);
        }
        if (this.isInstanceOf(tRawType, (Type)((Object)List.class))) {
            Class componentType = (Class)tParameterizedType.getActualTypeArguments()[0];
            return this.generateCollectionComplexType(context, context.getDescription().getTargetNamespace(), "List", componentType);
        }
        if (this.isInstanceOf(tRawType, (Type)((Object)Set.class))) {
            Class componentType = (Class)tParameterizedType.getActualTypeArguments()[0];
            return this.generateCollectionComplexType(context, context.getDescription().getTargetNamespace(), "Set", componentType);
        }
        this.unknownType(type);
        return SchemaFactory.getDefaultSchema().getType(new QName(XML_SCHEMA_PREFIX, "anyType"));
    }

    private org.ow2.easywsdl.schema.api.Type getSchemaSimpleType(Type type) {
        if (Boolean.TYPE.equals(type) || Boolean.class.equals((Object)type)) {
            return SchemaFactory.getDefaultSchema().getType(new QName(XML_SCHEMA_PREFIX, "boolean"));
        }
        if (Character.TYPE.equals(type) || Character.class.equals((Object)type)) {
            return SchemaFactory.getDefaultSchema().getType(new QName(XML_SCHEMA_PREFIX, "short"));
        }
        if (Byte.TYPE.equals(type) || Byte.class.equals((Object)type)) {
            return SchemaFactory.getDefaultSchema().getType(new QName(XML_SCHEMA_PREFIX, "byte"));
        }
        if (Short.TYPE.equals(type) || Short.class.equals((Object)type)) {
            return SchemaFactory.getDefaultSchema().getType(new QName(XML_SCHEMA_PREFIX, "short"));
        }
        if (Integer.TYPE.equals(type) || Integer.class.equals((Object)type)) {
            return SchemaFactory.getDefaultSchema().getTypeInt();
        }
        if (Long.TYPE.equals(type) || Long.class.equals((Object)type)) {
            return SchemaFactory.getDefaultSchema().getType(new QName(XML_SCHEMA_PREFIX, "long"));
        }
        if (Float.TYPE.equals(type) || Float.class.equals((Object)type)) {
            return SchemaFactory.getDefaultSchema().getType(new QName(XML_SCHEMA_PREFIX, "float"));
        }
        if (Double.TYPE.equals(type) || Double.class.equals((Object)type)) {
            return SchemaFactory.getDefaultSchema().getType(new QName(XML_SCHEMA_PREFIX, "double"));
        }
        if (String.class.equals((Object)type)) {
            return SchemaFactory.getDefaultSchema().getTypeString();
        }
        if (Date.class.equals((Object)type)) {
            return SchemaFactory.getDefaultSchema().getType(new QName(XML_SCHEMA_PREFIX, "dateTime"));
        }
        return null;
    }

    private org.ow2.easywsdl.schema.api.Type generateCollectionComplexType(WSDLGenerationContext context, String namespace, String collectionType, Class<?> componentType) {
        String name = collectionType + "Of" + componentType.getSimpleName();
        Schema schema = context.getSchema(namespace);
        org.ow2.easywsdl.schema.api.Type type = (org.ow2.easywsdl.schema.api.Type)schema.getType(new QName(namespace, name));
        if (type == null) {
            ComplexType cType = (ComplexType)schema.createComplexType();
            type = cType;
            cType.setQName(new QName(namespace, name));
            schema.addType((AbsItfType)cType);
            Sequence sequence = (Sequence)cType.createSequence();
            cType.setSequence((AbsItfSequence)sequence);
            Element elem = (Element)sequence.createElement();
            org.ow2.easywsdl.schema.api.Type elemType = this.getSchemaSimpleType(componentType);
            if (elemType == null) {
                elemType = this.generateComplexType(context, componentType, new ArrayList());
                if ("".equals(this.namespace)) {
                    elem.setQName(new QName(this.createNamespace(componentType.getPackage()), componentType.getSimpleName()));
                } else {
                    elem.setQName(new QName(this.namespace, componentType.getSimpleName()));
                }
            } else {
                elem.setQName(elemType.getQName());
            }
            elem.setType((AbsItfType)elemType);
            elem.setMinOccurs(0);
            elem.setMaxOccurs("unbounded");
            sequence.addElement((AbsItfElement)elem);
        }
        return type;
    }

    private org.ow2.easywsdl.schema.api.Type generateComplexType(WSDLGenerationContext context, Class<?> clazz, List<Class<?>> processedClasses) {
        String name = clazz.getSimpleName();
        String namespace = "".equals(this.namespace) ? this.createNamespace(clazz.getPackage()) : this.namespace;
        Schema schema = context.getSchema(namespace);
        org.ow2.easywsdl.schema.api.Type type = (org.ow2.easywsdl.schema.api.Type)schema.getType(new QName(namespace, name));
        if (type == null) {
            this.debug("Generate Schema for type {" + namespace + "}" + name);
            processedClasses.add(clazz);
            ComplexType cType = (ComplexType)schema.createComplexType();
            type = cType;
            cType.setQName(new QName(namespace, name));
            schema.addType((AbsItfType)cType);
            this.generateFields(context, cType, clazz, processedClasses);
        }
        return type;
    }

    private void generateFields(WSDLGenerationContext context, ComplexType cType, Class<?> clazz, List<Class<?>> processedClasses) {
        if (!this.polymorph) {
            Sequence sequence = (Sequence)cType.createSequence();
            cType.setSequence((AbsItfSequence)sequence);
            Field[] fields = clazz.getDeclaredFields();
            this.generateFields(context, sequence, processedClasses, clazz, fields);
            while (Object.class != clazz) {
                if (processedClasses.contains(clazz = clazz.getSuperclass())) continue;
                processedClasses.add(clazz);
                fields = clazz.getDeclaredFields();
                this.generateFields(context, sequence, processedClasses, clazz, fields);
            }
        } else {
            Class<?> superClazz = clazz.getSuperclass();
            if (Object.class != superClazz) {
                ComplexContent cContent = (ComplexContent)cType.createComplexContent();
                Extension ext = (Extension)cContent.createExtension();
                Sequence sequence = (Sequence)ext.createSequence();
                ext.setSequence((AbsItfSequence)sequence);
                Field[] fields = clazz.getDeclaredFields();
                this.generateFields(context, sequence, processedClasses, clazz, fields);
                org.ow2.easywsdl.schema.api.Type baseType = this.getSchemaSimpleType(superClazz);
                if (baseType == null) {
                    ext.setBase((AbsItfType)this.generateComplexType(context, superClazz, processedClasses));
                } else {
                    ext.setBase((AbsItfType)baseType);
                }
                cContent.setExtension((AbsItfExtension)ext);
                cType.setComplexContent((AbsItfComplexContent)cContent);
            } else {
                Sequence sequence = (Sequence)cType.createSequence();
                cType.setSequence((AbsItfSequence)sequence);
                Field[] fields = clazz.getDeclaredFields();
                this.generateFields(context, sequence, processedClasses, clazz, fields);
            }
        }
    }

    private void generateFields(WSDLGenerationContext context, Sequence sequence, List<Class<?>> processedClasses, Class<?> clazz, Field[] fields) {
        for (Field field : fields) {
            if (field.getModifiers() == 26) continue;
            org.ow2.easywsdl.schema.api.Type fieldType = this.getSchemaSimpleType(field.getType());
            Element elem = (Element)sequence.createElement();
            if ("".equals(this.namespace)) {
                elem.setQName(new QName(this.createNamespace(clazz.getPackage()), field.getName()));
            } else {
                elem.setQName(new QName(this.namespace, field.getName()));
            }
            elem.setMinOccurs(0);
            if (fieldType == null) {
                if (field.getGenericType() instanceof ParameterizedType) {
                    ParameterizedType pType = (ParameterizedType)field.getGenericType();
                    if (this.isInstanceOf(pType.getRawType(), (Type)((Object)List.class))) {
                        elem.setType((AbsItfType)this.getXMLSchemaType(context, pType.getActualTypeArguments()[0]));
                        elem.setMaxOccurs("unbounded");
                    }
                } else if (field.getType().isArray()) {
                    elem.setType((AbsItfType)this.getXMLSchemaType(context, field.getType().getComponentType()));
                    elem.setMaxOccurs("unbounded");
                } else {
                    elem.setType((AbsItfType)this.generateComplexType(context, field.getType(), processedClasses));
                }
            } else {
                elem.setType((AbsItfType)fieldType);
            }
            elem.setMinOccurs(0);
            sequence.addElement((AbsItfElement)elem);
        }
    }

    private String createNamespace(Package package1) {
        StringTokenizer tok = new StringTokenizer(package1.getName(), ".");
        String[] packageNameElements = new String[tok.countTokens()];
        for (int i = 0; i < packageNameElements.length; ++i) {
            packageNameElements[packageNameElements.length - i - 1] = tok.nextToken();
        }
        StringBuffer sb = new StringBuffer();
        sb.append("http://");
        for (int i = 0; i < packageNameElements.length; ++i) {
            sb.append(packageNameElements[i]);
            if (i >= packageNameElements.length - 1) continue;
            sb.append('.');
        }
        return sb.toString();
    }

    private boolean isInstanceOf(Type clazz, Type other) {
        boolean res = other.equals(clazz);
        if (clazz instanceof Class) {
            Type[] interfaces;
            for (Type itf : interfaces = ((Class)clazz).getGenericInterfaces()) {
                if (itf instanceof ParameterizedType) {
                    res = res || other.equals(((ParameterizedType)itf).getRawType());
                    continue;
                }
                if (!(itf instanceof Class)) continue;
                res = res || other.equals(itf);
            }
            res = res || this.isInstanceOf(((Class)clazz).getSuperclass(), other);
        }
        return res;
    }

    private void unknownType(Type type) {
        this.debug("XML Schema Generation Not Yet Implemented for " + type + "\n Please fill in a bug with and attach sample code");
    }

    private void debug(String message) {
        if (this.verbose) {
            System.out.println("debug " + message);
        }
    }

    private QName cQName(String name) {
        return new QName(this.namespace, name);
    }
}

