/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.rules.manager.ejb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.ow2.jasmine.rules.manager.ejb.RulePackageEB;
import org.ow2.jasmine.rules.manager.ejb.TextualRulePackageEB;
import org.ow2.jasmine.rules.manager.ejb.VisualRulePackageEB;
import org.ow2.jasmine.rules.manager.model.AbstractRulePackage;
import org.ow2.jasmine.rules.manager.model.IRulePackage;
import org.ow2.jasmine.rules.manager.model.textual.TextualRulePackage;
import org.ow2.jasmine.rules.manager.model.visual.IRule;
import org.ow2.jasmine.rules.manager.model.visual.Rule;
import org.ow2.jasmine.rules.manager.model.visual.VisualRulePackage;
import org.ow2.jasmine.rules.manager.persistence.RulePackageSLBRemote;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless(mappedName="db-ejb/rule")
@Remote(value={RulePackageSLBRemote.class})
public class RulePackageSLB
implements RulePackageSLBRemote {
    @PersistenceContext
    private EntityManager entityManager = null;

    public final void saveRulePackage(IRulePackage r) throws Exception {
        this.deleteRulePackage(r);
        RulePackageEB rpEntityBean = new RulePackageEB();
        rpEntityBean.setDisplayName(r.getDisplayName());
        rpEntityBean.setState(r.getState());
        rpEntityBean.setSystemName(r.getSystemName());
        rpEntityBean.setDescription(r.getDescription());
        rpEntityBean.setRuleEngineInstanceName(r.getRuleEngineInstanceName());
        if (r instanceof TextualRulePackage) {
            TextualRulePackageEB trpEntityBean = this.saveTextualRulePackage((TextualRulePackage)r);
            rpEntityBean.setTextualRulePackageEB(trpEntityBean);
        } else if (r instanceof VisualRulePackage) {
            VisualRulePackageEB vrpEntityBean = this.saveVisualRulePackage((VisualRulePackage)r);
            rpEntityBean.setVisualRulePackageEB(vrpEntityBean);
        }
        this.entityManager.persist((Object)rpEntityBean);
    }

    public final void deleteRulePackage(IRulePackage r) throws Exception {
        String stringQuery = "SELECT e FROM RulePackageEB e WHERE e.systemName LIKE '";
        stringQuery = r.getPreviousSystemName() != null ? stringQuery + r.getPreviousSystemName() : stringQuery + r.getSystemName();
        stringQuery = stringQuery + "' AND e.ruleEngineInstanceName LIKE '" + r.getRuleEngineInstanceName() + "'";
        try {
            RulePackageEB rpEntityBean = (RulePackageEB)this.entityManager.createQuery(stringQuery).getSingleResult();
            if (rpEntityBean != null) {
                if (r instanceof TextualRulePackage) {
                    this.entityManager.remove((Object)rpEntityBean.getTextualRulePackageEB());
                } else if (r instanceof VisualRulePackage) {
                    this.entityManager.remove((Object)rpEntityBean.getVisualRulePackageEB());
                }
                this.entityManager.remove((Object)rpEntityBean);
            }
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
    }

    public final IRulePackage[] getRulePackages(Integer id, String systemName, String displayName, String ruleEngineInstanceName, String description, String state, String orderBy, Integer limit) throws Exception {
        HashMap<String, Object> queryElements = new HashMap<String, Object>();
        queryElements.put("id", id);
        queryElements.put("systemName", systemName);
        queryElements.put("displayName", displayName);
        queryElements.put("ruleEngineInstanceName", ruleEngineInstanceName);
        queryElements.put("description", description);
        queryElements.put("state", state);
        StringBuffer stringQuery = new StringBuffer("SELECT e FROM RulePackageEB e");
        for (String key : queryElements.keySet()) {
            if (queryElements.get(key) == null) continue;
            if (stringQuery.length() > "SELECT e FROM RulePackageEB e".length()) {
                stringQuery.append(" AND ");
            } else {
                stringQuery.append(" WHERE ");
            }
            stringQuery.append("e.");
            stringQuery.append(key);
            stringQuery.append(" LIKE :");
            stringQuery.append(key);
        }
        if (orderBy != null) {
            stringQuery.append(" ORDER BY e.");
            stringQuery.append(orderBy);
            stringQuery.append(" ASC");
        }
        Query dbQuery = this.entityManager.createQuery(stringQuery.toString());
        if (limit != null) {
            dbQuery.setMaxResults(limit.intValue());
        }
        for (String key : queryElements.keySet()) {
            if (queryElements.get(key) == null) continue;
            dbQuery.setParameter(key, queryElements.get(key));
        }
        List queryResult = dbQuery.getResultList();
        if (queryResult.size() < 1) {
            return null;
        }
        int i = 0;
        IRulePackage[] result = new IRulePackage[queryResult.size()];
        for (RulePackageEB bean : queryResult) {
            if (bean.getTextualRulePackageEB() != null) {
                TextualRulePackage trp = new TextualRulePackage();
                trp.setDisplayName(bean.getDisplayName());
                trp.setRuleEngineInstanceName(bean.getRuleEngineInstanceName());
                trp.setPreviousSystemName(null);
                trp.setState(bean.getState());
                trp.setSystemName(bean.getSystemName());
                trp.setDescription(bean.getDescription());
                trp.setContent(bean.getTextualRulePackageEB().getContent());
                result[i++] = trp;
                continue;
            }
            if (bean.getVisualRulePackageEB() == null) continue;
            VisualRulePackage vrp = new VisualRulePackage();
            vrp.setDisplayName(bean.getDisplayName());
            vrp.setRuleEngineInstanceName(bean.getRuleEngineInstanceName());
            vrp.setPreviousSystemName(null);
            vrp.setSystemName(bean.getSystemName());
            vrp.setDescription(bean.getDescription());
            vrp.setState(bean.getState());
            vrp.setImports(bean.getVisualRulePackageEB().getImports());
            ArrayList<Rule> lIRule = new ArrayList<Rule>();
            ArrayList<Rule> lrEntityBean = bean.getVisualRulePackageEB().getRules();
            for (Rule rule : lrEntityBean) {
                lIRule.add(rule);
            }
            vrp.setRules(lIRule);
            result[i++] = vrp;
        }
        return result;
    }

    public final int countRulePackages() {
        String stringQuery = "SELECT COUNT(e) FROM RulePackageEB e";
        Query dbQuery = this.entityManager.createQuery(stringQuery);
        return Integer.parseInt(dbQuery.getSingleResult().toString());
    }

    public final int countRulePackages(String ruleEngineInstanceName) {
        String stringQuery = "SELECT COUNT(e) FROM RulePackageEB e WHERE e.ruleEngineInstanceName LIKE '" + ruleEngineInstanceName + "'";
        Query dbQuery = this.entityManager.createQuery(stringQuery);
        return Integer.parseInt(dbQuery.getSingleResult().toString());
    }

    public final List<String> getRuleEngineInstancesToManage() {
        String stringQuery = "SELECT DISTINCT e.ruleEngineInstanceName FROM RulePackageEB AS e WHERE e.state LIKE '" + AbstractRulePackage.ACTIVATED + "'";
        Query dbQuery = this.entityManager.createQuery(stringQuery);
        List queryResult = dbQuery.getResultList();
        ArrayList<String> res = new ArrayList<String>();
        for (String s : queryResult) {
            if (res == null || ((Object)res).equals("null")) continue;
            res.add(s);
        }
        return res;
    }

    public Boolean checkNameAvailability(String systemName, String ruleEngineInstanceName) throws Exception {
        String stringQuery = "SELECT COUNT(e) FROM RulePackageEB e WHERE e.systemName LIKE '" + systemName + "' " + "AND e.ruleEngineInstanceName LIKE '" + ruleEngineInstanceName + "'";
        Query dbQuery = this.entityManager.createQuery(stringQuery);
        return Integer.parseInt(dbQuery.getSingleResult().toString()) == 0;
    }

    private TextualRulePackageEB saveTextualRulePackage(TextualRulePackage r) throws Exception {
        TextualRulePackageEB trpEntityBean = new TextualRulePackageEB();
        trpEntityBean.setContent(r.getContent());
        this.entityManager.persist((Object)trpEntityBean);
        return trpEntityBean;
    }

    private VisualRulePackageEB saveVisualRulePackage(VisualRulePackage r) throws Exception {
        VisualRulePackageEB vrpEntityBean = new VisualRulePackageEB();
        vrpEntityBean.setImports((ArrayList)r.getImports());
        ArrayList<Rule> lRuleEntityBean = new ArrayList<Rule>();
        for (IRule ir : r.getRules()) {
            lRuleEntityBean.add((Rule)ir);
        }
        vrpEntityBean.setRules(lRuleEntityBean);
        this.entityManager.persist((Object)vrpEntityBean);
        return vrpEntityBean;
    }
}

