/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.audit;

import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.ow2.jasmine.monitoring.mbeancmd.audit.AuditContext;
import org.ow2.jasmine.monitoring.mbeancmd.audit.Metric;
import org.ow2.jasmine.monitoring.mbeancmd.audit.PollID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Collector {
    private ObjectName onPattern = null;
    private String[] attributes = null;
    private AuditContext[] context = null;
    private HashMap<PollID, LinkedList<Metric>> polls = new HashMap();
    private PrintStream perr = null;

    public PollID poll(String name) {
        PollID id = new PollID(name);
        LinkedList<Metric> metrics = new LinkedList<Metric>();
        for (int i = 0; i < this.context.length; ++i) {
            this.pollTarget(this.context[i], metrics);
        }
        id.setStamp();
        this.polls.put(id, metrics);
        this.perr.println("End of poll : " + id);
        this.perr.flush();
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollTarget(AuditContext ctx, LinkedList<Metric> metrics) {
        this.perr.print("Polling " + ctx.getName() + " ... ");
        this.perr.flush();
        int n0 = metrics.size();
        int errors = 0;
        int tries = 0;
        MBeanServerConnection cnx = null;
        try {
            cnx = ctx.getJmxap().getMBeanServerConnection();
            Set<ObjectName> onset = cnx.queryNames(this.onPattern, null);
            Iterator<ObjectName> it = onset.iterator();
            while (it.hasNext()) {
                ++tries;
                long t = System.currentTimeMillis();
                ObjectName on = it.next();
                try {
                    AttributeList attl = cnx.getAttributes(on, this.attributes);
                    metrics.add(new Metric(t, ctx.getName(), on, attl));
                }
                catch (InstanceNotFoundException e) {
                    e.printStackTrace(this.perr);
                    ++errors;
                }
                catch (ReflectionException e) {
                    e.printStackTrace(this.perr);
                    ++errors;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace(this.perr);
            ++errors;
        }
        finally {
            ctx.getJmxap().releaseMBeanServerConnection();
        }
        this.perr.print(" " + (metrics.size() - n0) + " mbeans collected (" + tries + " tries, " + errors + " errors).");
        this.perr.flush();
    }

    public LinkedList<Metric> getPoll(PollID id) {
        return this.polls.get(id);
    }

    public AuditContext[] getContext() {
        return this.context;
    }

    public void setContext(AuditContext[] context) {
        this.context = context;
    }

    public ObjectName getOnPattern() {
        return this.onPattern;
    }

    public void setOnPattern(ObjectName onPattern) {
        this.onPattern = onPattern;
    }

    public String[] getAttributes() {
        return this.attributes;
    }

    public void setAttributes(String[] attributes) {
        this.attributes = attributes;
    }

    public PrintStream getPerr() {
        return this.perr;
    }

    public void setPerr(PrintStream perr) {
        this.perr = perr;
    }
}

