/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.audit.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.management.Attribute;
import org.ow2.jasmine.monitoring.mbeancmd.audit.Metric;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetricMath {
    public static final double MIN_RANGE = -100.0;
    private static final HashMap<Class, Class> numerics = new HashMap();

    public static double sum(String attr, LinkedList<Metric> l) {
        double ret = 0.0;
        boolean isValid = false;
        if (!l.isEmpty()) {
            Attribute att = l.peek().getAttribute(attr);
            boolean bl = isValid = att != null && MetricMath.isNum(att.getValue());
        }
        if (isValid) {
            Iterator it = l.iterator();
            while (it.hasNext()) {
                ret += MetricMath.toDouble(((Metric)it.next()).getAttribute(attr));
            }
        }
        return ret;
    }

    public static double toDouble(Attribute attr) {
        double ret = 0.0;
        if (attr != null && MetricMath.isNum(attr.getValue())) {
            ret = MetricMath.toDouble(attr.getValue());
        }
        return ret;
    }

    public static double toDouble(Object o) {
        double ret = 0.0;
        Class<?> cl = o.getClass();
        if (cl.equals(Integer.class)) {
            ret = ((Integer)o).doubleValue();
        } else if (cl.equals(Long.class)) {
            ret = ((Long)o).doubleValue();
        } else if (cl.equals(Short.class)) {
            ret = ((Short)o).doubleValue();
        } else if (cl.equals(Byte.class)) {
            ret = ((Byte)o).doubleValue();
        } else if (cl.equals(Short.class)) {
            ret = ((Short)o).doubleValue();
        } else if (cl.equals(Float.class)) {
            ret = ((Float)o).doubleValue();
        } else if (cl.equals(Double.class)) {
            ret = (Double)o;
        }
        return ret;
    }

    public static double range(double d) {
        d = (d = Math.abs(d)) == 0.0 ? -100.0 : Math.log10(d);
        double ret = Math.max(d, -100.0);
        return ret;
    }

    public static boolean isNum(Object obj) {
        return obj == null || obj.getClass().isPrimitive() || numerics.containsKey(obj.getClass());
    }

    public static boolean isNonZero(Attribute att) {
        boolean ret = true;
        Object value = att.getValue();
        Class<?> cl = att.getValue().getClass();
        if (cl.equals(Integer.class) || cl.equals(Integer.TYPE)) {
            if (Integer.valueOf(0).equals(value)) {
                ret = false;
            }
        } else if (cl.equals(Long.class) || cl.equals(Long.TYPE)) {
            if (Long.valueOf(0L).equals(value)) {
                ret = false;
            }
        } else if (cl.equals(Short.class) || cl.equals(Short.TYPE)) {
            if (Short.valueOf((short)0).equals(value)) {
                ret = false;
            }
        } else if (cl.equals(Float.class) || cl.equals(Float.TYPE)) {
            if (Float.valueOf(0.0f).equals(value)) {
                ret = false;
            }
        } else if (cl.equals(Double.class) || cl.equals(Double.TYPE)) {
            if (Double.valueOf(0.0).equals(value)) {
                ret = false;
            }
        } else if (cl.equals(Character.class) || cl.equals(Character.TYPE)) {
            if (Character.valueOf('\u0000').equals(value)) {
                ret = false;
            }
        } else if ((cl.equals(Byte.class) || cl.equals(Byte.TYPE)) && Byte.valueOf((byte)0).equals(value)) {
            ret = false;
        }
        return ret;
    }

    static {
        numerics.put(Byte.class, Byte.class);
        numerics.put(Short.class, Short.class);
        numerics.put(Integer.class, Integer.class);
        numerics.put(Long.class, Long.class);
        numerics.put(Float.class, Float.class);
        numerics.put(Double.class, Double.class);
    }
}

