/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.commands;

import org.ow2.jasmine.monitoring.mbeancmd.Command;
import org.ow2.jasmine.monitoring.mbeancmd.CommandDispatcher;

public class Help
implements Command {
    private String name = null;
    private String[] arguments = null;

    public void setArgs(String cmd, String[] args) {
        this.name = cmd.toLowerCase();
        this.arguments = args;
    }

    public int exec(CommandDispatcher cmdDispatcher) {
        if (this.arguments == null) {
            System.out.println("\nAvailable commands:\n");
            String[] cmds = cmdDispatcher.getAvailableCommands();
            for (int i = 0; i < cmds.length; ++i) {
                Command cmd = cmdDispatcher.getCommand(cmds[i]);
                System.out.println(cmds[i] + " - " + cmd.summary());
            }
            System.out.println();
            this.help();
        } else {
            for (int i = 0; i < this.arguments.length; ++i) {
                Command cmd = cmdDispatcher.getCommand(this.arguments[i]);
                if (cmd == null) {
                    System.out.println("Unknown command: " + this.arguments[i]);
                } else {
                    cmd.help();
                }
                System.out.println();
            }
        }
        return 0;
    }

    public String summary() {
        return "provides help on available commands";
    }

    public void help() {
        System.out.println("Usage: help [ command, ... ]\n\t- without arguments, lists a summary of the available commands\n\t- with arguments, prints full help for each passed command\n");
    }

    public String getName() {
        return this.name;
    }
}

