/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.commands;

import java.io.File;
import java.io.IOException;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.ow2.jasmine.monitoring.mbeancmd.AbstractCommand;
import org.ow2.jasmine.monitoring.mbeancmd.CommandDispatcher;
import org.ow2.jasmine.monitoring.mbeancmd.JmxAp;
import org.ow2.jasmine.monitoring.mbeancmd.JmxHelper;
import org.ow2.jasmine.monitoring.mbeancmd.Outer;
import org.ow2.jasmine.monitoring.mbeancmd.commands.MonologNotificationListener;
import org.ow2.jasmine.monitoring.mbeancmd.context.MonologContext;
import org.ow2.jasmine.monitoring.mbeancmd.jasmine.JasmineConnector;

public class MonologJMX
extends AbstractCommand {
    private Options options = null;
    private CommandLine commandLine = null;
    private MonologContext[] context = null;

    public MonologJMX() {
        this.setOptions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int exec(CommandDispatcher cmdDispatcher) {
        String[] managee;
        try {
            this.parseCommandLine(this.arguments);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        PipedOutputStream out = new PipedOutputStream();
        PrintStream pout = new PrintStream(out);
        Outer outer = null;
        try {
            String jasmineURI;
            String outputFilePath;
            if (this.commandLine.hasOption("f") && (outputFilePath = this.commandLine.getOptionValue("f")) != null) {
                outer = new Outer(out, new File(outputFilePath));
            }
            if (this.commandLine.hasOption("jasmine") && (jasmineURI = this.commandLine.getOptionValue("jasmine")) != null) {
                if (outer == null) {
                    outer = JasmineConnector.connect(out, jasmineURI);
                } else {
                    Outer oldOuter = outer;
                    outer = JasmineConnector.connect(outer, jasmineURI);
                    new Thread(oldOuter).start();
                }
            }
            if (outer == null) {
                outer = new Outer(out, System.out);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        new Thread(outer).start();
        String[] targets = JmxHelper.getJmxTargets(this.commandLine.getOptionValues("target"));
        if (targets != null && targets.length > 0) {
            this.context = new MonologContext[targets.length];
            for (int i = 0; i < this.context.length; ++i) {
                this.context[i] = new MonologContext();
                this.context[i].setName(targets[i]);
                this.context[i].setJmxUrl(JmxHelper.getJmxUrl(targets[i]));
                this.context[i].setJmxap(new JmxAp(this.context[i].getJmxUrl(), null));
                try {
                    ObjectName j2eeinstance = ObjectName.getInstance("*:j2eeType=J2EEServer,*");
                    MBeanServerConnection mbscnx = this.context[i].getJmxap().getMBeanServerConnection(false);
                    Iterator<ObjectName> onames = mbscnx.queryNames(j2eeinstance, null).iterator();
                    this.context[i].setServer(null);
                    while (this.context[i].getServer() == null) {
                        ObjectName server = onames.next();
                        this.context[i].setServer((String)mbscnx.getAttribute(server, "serverName"));
                        this.context[i].setDomain(server.getDomain());
                    }
                }
                catch (Exception e) {
                    this.context[i].setServer("unknown_server_name");
                    this.context[i].setDomain("unknown_domain");
                }
                finally {
                    this.context[i].getJmxap().releaseMBeanServerConnection();
                }
                System.err.println("Target " + this.context[i].getName() + " - " + this.context[i].getJmxUrl());
            }
        }
        if ((managee = JmxHelper.getJmxTargets(this.commandLine.getOptionValues("target"))) != null && managee.length > 0) {
            for (int i = 0; i < managee.length; ++i) {
                try {
                    JmxAp jmxAp = new JmxAp(JmxHelper.getJmxUrl(managee[i]), cmdDispatcher);
                    ObjectName on = ObjectName.getInstance("*:type=service,name=log,*");
                    MBeanServerConnection mbscnx = null;
                    MonologContext context = new MonologContext();
                    context.setJmxap(jmxAp);
                    try {
                        ObjectName j2eeinstance = ObjectName.getInstance("*:j2eeType=J2EEServer,*");
                        mbscnx = jmxAp.getMBeanServerConnection(false);
                        Iterator<ObjectName> onames = mbscnx.queryNames(j2eeinstance, null).iterator();
                        context.setServer(null);
                        while (context.getServer() == null) {
                            ObjectName server = onames.next();
                            context.setServer((String)mbscnx.getAttribute(server, "serverName"));
                            context.setDomain(server.getDomain());
                        }
                    }
                    catch (Exception e) {
                        context.setServer("unknown_server_name");
                        context.setDomain("unknown_domain");
                    }
                    finally {
                        mbscnx = null;
                    }
                    context.setJmxUrl(JmxHelper.getJmxUrl(managee[i]));
                    context.setName(managee[i]);
                    MonologNotificationListener listener = new MonologNotificationListener(pout, context);
                    Set<ObjectName> objectNames = jmxAp.getMBeanServerConnection().queryNames(on, null);
                    if (objectNames.size() != 1) {
                        System.err.println("Unable to retrieve the MBean of service log!");
                    }
                    jmxAp.getMBeanServerConnection(false).addNotificationListener((ObjectName)objectNames.toArray()[0], listener, null, null);
                    continue;
                }
                catch (MalformedObjectNameException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (InstanceNotFoundException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            System.err.println("No target specified!");
            return 2;
        }
        while (true) {
            try {
                while (true) {
                    Thread.sleep(Long.MAX_VALUE);
                }
            }
            catch (InterruptedException e) {
                continue;
            }
            break;
        }
    }

    public String summary() {
        return "Returns Monolog logs from a given JavaEE server";
    }

    public void parseCommandLine(String[] args) throws ParseException {
        BasicParser bp = new BasicParser();
        this.commandLine = bp.parse(this.options, args);
    }

    public void setOptions() {
        this.options = new Options();
        Option file = new Option("f", "file", true, "Send output to file instead of stdout");
        file.setRequired(false);
        file.setArgName("path");
        file.setArgs(1);
        this.options.addOption(file);
        Option jasmine = new Option("jasmine", "jasmine", true, "Output logged data to jasmine (will disable stdout)");
        jasmine.setRequired(false);
        jasmine.setArgName("jasmineURI");
        jasmine.setArgs(1);
        this.options.addOption(jasmine);
        Option target = new Option("target", "target", true, "instances to probe");
        target.setRequired(false);
        target.setOptionalArg(true);
        target.setArgs(-2);
        target.setArgName("instances");
        this.options.addOption(target);
    }
}

