/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.commands;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.TreeSet;
import javax.management.MalformedObjectNameException;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.ow2.jasmine.monitoring.mbeancmd.AbstractCommand;
import org.ow2.jasmine.monitoring.mbeancmd.CommandDispatcher;
import org.ow2.jasmine.monitoring.mbeancmd.audit.FileCollector;
import org.ow2.jasmine.monitoring.mbeancmd.audit.Metric;
import org.ow2.jasmine.monitoring.mbeancmd.audit.MetricSorter;

public class Scan
extends AbstractCommand {
    private Options options = null;
    private CommandLine commandLine = null;
    private String[] sort_attr = null;
    private int sortMode = -1;
    private CommandDispatcher cmdDispatcher = null;
    private boolean printZeroValue = false;
    private boolean isDelta = false;
    private String inputFile = null;
    private boolean isSeparator = true;
    private String separator = ";";
    private boolean isStats = false;

    public Scan() {
        this.setOptions();
    }

    public int exec(CommandDispatcher cmdDispatcher) {
        this.cmdDispatcher = cmdDispatcher;
        try {
            this.parseCommandLine(this.arguments);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return 1;
        }
        FileCollector fc = null;
        if (this.inputFile != null) {
            try {
                fc = new FileCollector(new File(this.inputFile));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace(System.err);
                return 1;
            }
        } else {
            fc = new FileCollector(System.in);
        }
        if (this.isSeparator) {
            fc.setSeparator(this.separator);
        }
        fc.setAttributes(this.sort_attr);
        if (this.isStats) {
            this.execStatistics(fc);
        } else {
            this.execNoStatistics(fc);
        }
        return 0;
    }

    private void execStatistics(FileCollector fc) {
        fc.enableStatistics();
        fc.scan();
        MetricSorter sorter = new MetricSorter();
        for (int i = 0; i < this.sort_attr.length; ++i) {
            TreeSet<Metric> tset = sorter.sort(fc.getStats(this.sort_attr[i]), this.sort_attr[i], this.sortMode);
            MetricSorter.printMetrics(System.out, tset, this.sort_attr[i], this.printZeroValue, true);
            System.out.println();
        }
    }

    private void execNoStatistics(FileCollector fc) {
        fc.scan();
        MetricSorter sorter = new MetricSorter();
        if (this.isDelta) {
            sorter.setBaseline(fc.getBaseline());
        }
        for (int i = 0; i < this.sort_attr.length; ++i) {
            TreeSet<Metric> tset = sorter.sort(fc.getPoll(), this.sort_attr[i], this.sortMode);
            MetricSorter.printMetrics(System.out, tset, this.sort_attr[i], this.printZeroValue);
            System.out.println();
        }
    }

    public String summary() {
        return "Scan a file or the standard input and prints a sorted output";
    }

    public static void main(String[] args) {
    }

    private void setOptions() {
        this.options = new Options();
        this.options.addOption("z", "zero", false, "print zero values (not printed per default)");
        Option atts = new Option("a", "atts", true, "attributes to poll");
        atts.setRequired(true);
        atts.setOptionalArg(false);
        atts.setArgs(-2);
        atts.setArgName("attributes");
        this.options.addOption(atts);
        Option sortMode = new Option("m", "mode", true, "Sort mode (ascending or descending)");
        sortMode.setRequired(false);
        sortMode.setOptionalArg(false);
        sortMode.setArgName("mode");
        sortMode.setArgs(1);
        this.options.addOption(sortMode);
        Option ifile = new Option("i", "input", true, "Input file");
        ifile.setRequired(false);
        ifile.setArgName("file");
        ifile.setArgs(1);
        this.options.addOption(ifile);
        Option separator = new Option("s", "separator", true, "Set the column separator");
        separator.setRequired(false);
        separator.setArgName("separator");
        separator.setArgs(1);
        this.options.addOption(separator);
        OptionGroup oper = new OptionGroup();
        oper.setRequired(false);
        Option current = new Option("current", "current", false, "retains the most recent metrics.");
        oper.addOption(current);
        Option delta = new Option("delta", "delta", false, "computes differences between the end and the beginning.");
        oper.addOption(delta);
        Option stats = new Option("stat", "stat", false, "computes statistics.");
        oper.addOption(stats);
        this.options.addOptionGroup(oper);
    }

    public void parseCommandLine(String[] args) throws ParseException, MalformedObjectNameException {
        Option opt;
        String oper;
        BasicParser bp = new BasicParser();
        this.commandLine = bp.parse(this.options, args);
        this.sort_attr = this.commandLine.getOptionValues("a");
        if (this.sort_attr == null) {
            throw new ParseException("Missing argument : -a option requires an attribute list");
        }
        if (this.commandLine.hasOption("m")) {
            String mode = this.commandLine.getOptionValue("m");
            if ("up".equalsIgnoreCase(mode)) {
                this.sortMode = 1;
            } else if ("down".equalsIgnoreCase(mode)) {
                this.sortMode = -1;
            }
        }
        if (this.commandLine.hasOption("z")) {
            this.printZeroValue = true;
        }
        if ("delta".equals(oper = this.options.getOptionGroup(opt = this.options.getOption("current")).getSelected())) {
            this.isDelta = true;
        } else if ("stat".equals(oper)) {
            this.isStats = true;
        }
        if (this.commandLine.hasOption("i")) {
            this.inputFile = this.commandLine.getOptionValue("i");
        }
        this.isSeparator = this.commandLine.hasOption("s");
        if (this.isSeparator) {
            this.separator = this.commandLine.getOptionValue("s");
        }
    }
}

