/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;

import java.util.HashMap;
import java.util.Map;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.SampleData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionBeanData
extends SampleData {
    private long numberOfCalls;
    private double callsRate;
    private long averageProcessingTime;
    private double averageProcessingTimeRequest;
    private long totalProcessingTime;
    private double totalProcessingTimeRequest;
    private final String header = "cacheSize;poolSize;minPoolSize;maxCacheSize;sessionTimeOut";
    private final String headerExt = ";totalProcessingTime;totalProcessingTimeReq;numberOfCalls;callsRate";

    @Override
    public void compute(SampleData needs_cast) {
        SessionBeanData prev = (SessionBeanData)needs_cast;
        if (prev != null) {
            double sampleTime = this.computeSamplePeriod(prev);
            long deltaCalls = this.numberOfCalls - prev.numberOfCalls;
            this.setCallsRate((double)deltaCalls / sampleTime);
            if (deltaCalls > 0L) {
                long deltaProcessingTime = this.totalProcessingTime - prev.totalProcessingTime;
                this.setTotalProcessingTimeRequest(1.0 * (double)deltaProcessingTime / (double)deltaCalls);
            }
        }
    }

    @Override
    protected String getInnerPrintHeader() {
        return "cacheSize;poolSize;minPoolSize;maxCacheSize;sessionTimeOut".replaceAll(";", SessionBeanData.getSeparator()) + ";totalProcessingTime;totalProcessingTimeReq;numberOfCalls;callsRate".replaceAll(";", SessionBeanData.getSeparator());
    }

    @Override
    protected String getInnerPrintData() {
        StringBuffer stringBuff = new StringBuffer();
        this.concatDataElement(stringBuff, this.getAttributeAsInt("cacheSize"), false);
        this.concatDataElement(stringBuff, this.getAttributeAsInt("poolSize"), false);
        this.concatDataElement(stringBuff, this.getAttributeAsInt("minPoolSize"), false);
        this.concatDataElement(stringBuff, this.getAttributeAsInt("maxCacheSize"), false);
        this.concatDataElement(stringBuff, this.getAttributeAsInt("sessionTimeOut"), false);
        this.concatDataElement(stringBuff, this.getTotalProcessingTime(), false);
        this.concatDataElement(stringBuff, decimalFormat.format(this.getTotalProcessingTimeRequest()), false);
        this.concatDataElement(stringBuff, this.getNumberOfCalls(), false);
        this.concatDataElement(stringBuff, decimalFormat.format(this.getCallsRate()), true);
        return new String(stringBuff);
    }

    @Override
    public Map<String, ?> getValueOfAttributes() {
        HashMap<String, Number> valueOfAttributes = new HashMap<String, Number>();
        valueOfAttributes.put("cacheSize", this.getAttributeAsInt("cacheSize"));
        valueOfAttributes.put("poolSize", this.getAttributeAsInt("poolSize"));
        valueOfAttributes.put("minPoolSize", this.getAttributeAsInt("minPoolSize"));
        valueOfAttributes.put("maxCacheSize", this.getAttributeAsInt("maxCacheSize"));
        valueOfAttributes.put("sessionTimeOut", this.getAttributeAsInt("sessionTimeOut"));
        valueOfAttributes.put("totalProcessingTime", this.getTotalProcessingTime());
        valueOfAttributes.put("totalProcessingTimeReq", this.getTotalProcessingTimeRequest());
        valueOfAttributes.put("numberOfCalls", this.getNumberOfCalls());
        valueOfAttributes.put("callsRate", this.getCallsRate());
        return valueOfAttributes;
    }

    public long getNumberOfCalls() {
        return this.numberOfCalls;
    }

    public void setNumberOfCalls(long numberOfCalls) {
        this.numberOfCalls = numberOfCalls;
    }

    public double getCallsRate() {
        return this.callsRate;
    }

    public void setCallsRate(double callsRate) {
        this.callsRate = callsRate;
    }

    public long getAverageProcessingTime() {
        return this.averageProcessingTime;
    }

    public void setAverageProcessingTime(long averageProcessingTime) {
        this.averageProcessingTime = averageProcessingTime;
    }

    public double getAverageProcessingTimeRequest() {
        return this.averageProcessingTimeRequest;
    }

    public void setAverageProcessingTimeRequest(double averageProcessingTimeRequest) {
        this.averageProcessingTimeRequest = averageProcessingTimeRequest;
    }

    public long getTotalProcessingTime() {
        return this.totalProcessingTime;
    }

    public void setTotalProcessingTime(long totalProcessingTime) {
        this.totalProcessingTime = totalProcessingTime;
    }

    public double getTotalProcessingTimeRequest() {
        return this.totalProcessingTimeRequest;
    }

    public void setTotalProcessingTimeRequest(double totalProcessingTimeRequest) {
        this.totalProcessingTimeRequest = totalProcessingTimeRequest;
    }
}

