/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;

import java.util.HashMap;
import java.util.Map;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.SampleData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebData
extends SampleData {
    private long sessionGauge = 0L;
    private long sessionCount = 0L;
    private long httpRequestCount = 0L;
    private long procTimeCount = 0L;
    private long maxProcTime = 0L;
    private long pendingHttpRequests = 0L;
    private long httpErrorCount = 0L;
    private double httpRequestRate = 0.0;
    private double procTimePerRequest = 0.0;
    private long bytesSentCount = 0L;
    private double bytesSentRate = 0.0;
    private long bytesReceivedCount = 0L;
    private double bytesReceivedRate = 0.0;
    private static final String header = "sessions;rate;requests;pending;errors;sessionCount;meanTime;maxTime;bytesSent;byteSentRate;bytesReceived;bytesReveivedRate";

    @Override
    public void compute(SampleData needs_cast) {
        WebData prev = (WebData)needs_cast;
        if (prev != null) {
            long deltaReq = this.httpRequestCount - prev.httpRequestCount;
            this.httpRequestRate = 1000.0 * (double)deltaReq / (double)(this.getSampleTime() - prev.getSampleTime());
            this.procTimePerRequest = deltaReq > 0L ? 1.0 * (double)(this.procTimeCount - prev.procTimeCount) / (double)deltaReq : 0.0;
            long deltaBytesSent = this.bytesSentCount - prev.bytesSentCount;
            this.bytesSentRate = 1000.0 * (double)deltaBytesSent / (double)(this.getSampleTime() - prev.getSampleTime());
            long deltaBytesReceived = this.bytesReceivedCount - prev.bytesReceivedCount;
            this.bytesReceivedRate = 1000.0 * (double)deltaBytesReceived / (double)(this.getSampleTime() - prev.getSampleTime());
        } else {
            this.httpRequestRate = 0.0;
            this.procTimePerRequest = 0.0;
            this.bytesSentRate = 0.0;
            this.bytesReceivedRate = 0.0;
        }
    }

    @Override
    protected String getInnerPrintHeader() {
        return header.replaceAll(";", WebData.getSeparator());
    }

    @Override
    protected String getInnerPrintData() {
        return this.getSessionGauge() + WebData.getSeparator() + decimalFormat.format(this.getHttpRequestRate()) + WebData.getSeparator() + this.getHttpRequestCount() + WebData.getSeparator() + this.getPendingHttpRequests() + WebData.getSeparator() + this.getHttpErrors() + WebData.getSeparator() + this.getSessionCount() + WebData.getSeparator() + decimalFormat.format(this.getProcTimePerRequest()) + WebData.getSeparator() + this.getMaxProcTime() + WebData.getSeparator() + this.getBytesSentCount() + WebData.getSeparator() + decimalFormat.format(this.getBytesSentRate()) + WebData.getSeparator() + this.getBytesReceivedCount() + WebData.getSeparator() + decimalFormat.format(this.getBytesReceivedRate());
    }

    public void setSessionGauge(long nb) {
        this.sessionGauge = nb;
    }

    public long getSessionGauge() {
        return this.sessionGauge;
    }

    public void setSessionCount(long nb) {
        this.sessionCount = nb;
    }

    public long getSessionCount() {
        return this.sessionCount;
    }

    public void setHttpRequestCount(long cnt) {
        this.httpRequestCount = cnt;
    }

    public long getHttpRequestCount() {
        return this.httpRequestCount;
    }

    public void setProcTimeCount(long cnt) {
        this.procTimeCount = cnt;
    }

    public long getProcTimeCount() {
        return this.procTimeCount;
    }

    public void setMaxProcTime(long time) {
        this.maxProcTime = time;
    }

    public long getMaxProcTime() {
        return this.maxProcTime;
    }

    public void setPendingHttpRequests(long gauge) {
        this.pendingHttpRequests = gauge;
    }

    public long getPendingHttpRequests() {
        return this.pendingHttpRequests;
    }

    public void setHttpErrorsCount(long cnt) {
        this.httpErrorCount = cnt;
    }

    public long getHttpErrors() {
        return this.httpErrorCount;
    }

    public double getHttpRequestRate() {
        return this.httpRequestRate;
    }

    public double getProcTimePerRequest() {
        return this.procTimePerRequest;
    }

    public void setBytesSentCount(long cnt) {
        this.bytesSentCount = cnt;
    }

    public long getBytesSentCount() {
        return this.bytesSentCount;
    }

    public void setBytesReceivedCount(long cnt) {
        this.bytesReceivedCount = cnt;
    }

    public long getBytesReceivedCount() {
        return this.bytesReceivedCount;
    }

    public double getBytesSentRate() {
        return this.bytesSentRate;
    }

    public double getBytesReceivedRate() {
        return this.bytesReceivedRate;
    }

    @Override
    public Map<String, ?> getValueOfAttributes() {
        HashMap<String, Number> valueOfAttributes = new HashMap<String, Number>();
        valueOfAttributes.put("sessions", this.sessionGauge);
        valueOfAttributes.put("rate", this.httpRequestRate);
        valueOfAttributes.put("requests", this.httpRequestCount);
        valueOfAttributes.put("pending", this.pendingHttpRequests);
        valueOfAttributes.put("errors", this.httpErrorCount);
        valueOfAttributes.put("sessionCount", this.sessionCount);
        valueOfAttributes.put("meanTime", this.procTimePerRequest);
        valueOfAttributes.put("maxTime", this.maxProcTime);
        valueOfAttributes.put("bytesSent", this.bytesSentCount);
        valueOfAttributes.put("bytesSentRate", this.bytesSentRate);
        valueOfAttributes.put("bytesReceived", this.bytesReceivedCount);
        valueOfAttributes.put("bytesReceivedRate", this.bytesReceivedRate);
        return valueOfAttributes;
    }
}

