/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.rules.manager.util.jndilocator;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.ow2.jasmine.rules.manager.util.jndilocator.ServiceLocatorException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class ServiceLocator {
    private static final Log LOGGER = LogFactory.getLog(ServiceLocator.class);
    private Context initialContext;
    private Map<String, Object> cache;
    private static final ServiceLocator instance = new ServiceLocator();

    public static ServiceLocator getInstance() {
        return instance;
    }

    private ServiceLocator() throws ServiceLocatorException {
        try {
            this.initialContext = this.getInitialContext();
            this.cache = new HashMap<String, Object>();
        }
        catch (Exception e) {
            LOGGER.debug((Object)"Error starting ServiceLocator", new Object[]{e});
            throw new ServiceLocatorException(e);
        }
    }

    public Context getInitialContext() throws ServiceLocatorException {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ServiceLocator.class.getClassLoader());
            InitialContext initialContext = new InitialContext();
            return initialContext;
        }
        catch (NamingException ne) {
            LOGGER.debug((Object)"Error getting Initial Context", new Object[]{ne});
            throw new ServiceLocatorException(ne);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    public Context getInitialContext(String url) throws ServiceLocatorException {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ServiceLocator.class.getClassLoader());
            Properties h = new Properties();
            h.put("java.naming.factory.initial", "org.ow2.carol.jndi.spi.MultiOrbInitialContextFactory");
            h.put("java.naming.provider.url", url);
            InitialContext initialContext = new InitialContext(h);
            return initialContext;
        }
        catch (NamingException ne) {
            LOGGER.debug((Object)"Error getting Initial Context", new Object[]{ne});
            throw new ServiceLocatorException(ne);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    public synchronized Object getRemoteObject(String jndiName) throws ServiceLocatorException {
        Object remoteObject = this.cache.get(jndiName);
        if (remoteObject == null) {
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(ServiceLocator.class.getClassLoader());
                remoteObject = this.initialContext.lookup(jndiName);
                this.cache.put(jndiName, remoteObject);
            }
            catch (Exception e) {
                LOGGER.debug((Object)"Error getting remote object", new Object[]{e});
                throw new ServiceLocatorException(e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCl);
            }
        }
        return remoteObject;
    }
}

