/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jasmine.rules.logs.impl;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateful;
import javax.interceptor.Interceptors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import org.objectweb.jasmine.rules.logs.beans.JMSLogInterceptor;
import org.objectweb.jasmine.rules.logs.beans.LogInterfaceLocal;
import org.objectweb.jasmine.rules.logs.beans.LogInterfaceRemote;
import org.objectweb.jasmine.rules.logs.beans.LogInterfaceRulesRemote;
import org.objectweb.jasmine.rules.logs.impl.LogEntity;
import org.objectweb.jasmine.rules.logs.util.AlarmLog;
import org.objectweb.jasmine.rules.logs.util.DBException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateful(mappedName="log_interface")
@Interceptors(value={JMSLogInterceptor.class})
@Remote(value={LogInterfaceRemote.class, LogInterfaceRulesRemote.class})
@Local(value={LogInterfaceLocal.class})
public class LogInterface
implements LogInterfaceRemote,
LogInterfaceRulesRemote,
LogInterfaceLocal {
    @PersistenceContext
    private EntityManager entityManager = null;

    public int addLogEntity(Date date, String level, String message) throws DBException {
        LogEntity logEntity = new LogEntity(date, level, message);
        try {
            this.entityManager.persist((Object)logEntity);
        }
        catch (Exception e) {
            throw new DBException("The logEntiy " + message + " cannot be added");
        }
        return logEntity.getLogEntityId();
    }

    public void deleteMessageBeforeDate(Date date) throws DBException {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.entityManager.createQuery("delete from LogEntity le where le.date <= '" + formatter.format(date) + "'").executeUpdate();
    }

    public AlarmLog getLog(int id) {
        LogEntity entity = (LogEntity)this.entityManager.find(LogEntity.class, (Object)id);
        return this.alarmFromEntity(entity);
    }

    public List<AlarmLog> getAllLogs() {
        Query query = this.entityManager.createQuery("select le from LogEntity as le order by le.logEntityId desc");
        return this.alarmListFromEntityList(query.getResultList());
    }

    public List<AlarmLog> getLastLogs(int nb) {
        Query query = this.entityManager.createQuery("select le from LogEntity as le order by le.logEntityId desc");
        query.setMaxResults(nb);
        return this.alarmListFromEntityList(query.getResultList());
    }

    public List<AlarmLog> getLogRange(int lowid, int highid) {
        Query query = this.entityManager.createQuery("select le from LogEntity as le where le.logEntityId between " + lowid + " and " + highid);
        return this.alarmListFromEntityList(query.getResultList());
    }

    public List<AlarmLog> getLogRange(String[] levels, Date startDate, Date endDate) {
        String levelList = this.inFromArray(levels);
        if (levelList.length() == 0) {
            return new ArrayList<AlarmLog>();
        }
        String queryString = "select le from LogEntity as le";
        queryString = queryString + " where le.level in (" + levelList + ")";
        if (startDate != null) {
            queryString = queryString + " and le.date >= :startdate";
        }
        if (endDate != null) {
            queryString = queryString + " and le.date <= :enddate";
        }
        Query query = this.entityManager.createQuery(queryString);
        if (startDate != null) {
            query.setParameter("startdate", startDate, TemporalType.TIMESTAMP);
        }
        if (endDate != null) {
            query.setParameter("enddate", endDate, TemporalType.TIMESTAMP);
        }
        return this.alarmListFromEntityList(query.getResultList());
    }

    public void delLog(int id) {
        this.entityManager.createQuery("delete from LogEntity le where le.logEntityId = '" + id + "'").executeUpdate();
    }

    public void delAllLogs() {
        this.entityManager.createQuery("delete from LogEntity").executeUpdate();
    }

    public void delLogRange(String[] levels, Date startDate, Date endDate) {
        String levelList = this.inFromArray(levels);
        if (levelList.length() == 0) {
            return;
        }
        String queryString = "delete from LogEntity le";
        queryString = queryString + " where le.level in (" + levelList + ")";
        if (startDate != null) {
            queryString = queryString + " and le.date >= :startdate";
        }
        if (endDate != null) {
            queryString = queryString + " and le.date <= :enddate";
        }
        Query query = this.entityManager.createQuery(queryString);
        if (startDate != null) {
            query.setParameter("startdate", startDate, TemporalType.TIMESTAMP);
        }
        if (endDate != null) {
            query.setParameter("enddate", endDate, TemporalType.TIMESTAMP);
        }
        query.executeUpdate();
    }

    private String inFromArray(String[] strings) {
        String list = "";
        for (String element : strings) {
            if ("".equals(element)) continue;
            list = list + "'" + element.toUpperCase() + "',";
        }
        if (list.length() == 0) {
            return "";
        }
        return list.substring(0, list.length() - 1);
    }

    private AlarmLog alarmFromEntity(LogEntity entity) {
        if (entity == null) {
            return null;
        }
        return new AlarmLog(entity.getLogEntityId(), new Date(entity.getDate().getTime()), entity.getLevel(), entity.getMessage());
    }

    private List<AlarmLog> alarmListFromEntityList(List<LogEntity> logEntities) {
        ArrayList<AlarmLog> logTable = new ArrayList<AlarmLog>();
        for (LogEntity entity : logEntities) {
            logTable.add(this.alarmFromEntity(entity));
        }
        return logTable;
    }
}

