/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.rules.manager.bundle;

import java.util.List;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.ow2.jasmine.rules.manager.persistence.RulePackageSLBRemote;
import org.ow2.jasmine.rules.manager.service.DroolsManagerFactory;
import org.ow2.jasmine.rules.manager.service.IDroolsManagerFactory;
import org.ow2.jasmine.rules.manager.util.jndilocator.ServiceLocator;

public class RuleEngineManagerBundleActivator
implements BundleActivator {
    private static Logger logger = Logger.getLogger(RuleEngineManagerBundleActivator.class.getName());
    public IDroolsManagerFactory droolsManagerFactory;
    private ServiceRegistration serviceRegistration;
    private RulePackageSLBRemote persistenceRemoteObject = null;

    public void start(BundleContext context) throws Exception {
        logger.info("Rule engine manager starting");
        this.droolsManagerFactory = new DroolsManagerFactory(context);
        this.serviceRegistration = context.registerService(IDroolsManagerFactory.class.getName(), (Object)this.droolsManagerFactory, null);
        try {
            this.persistenceRemoteObject = (RulePackageSLBRemote)ServiceLocator.getInstance().getRemoteObject("db-ejb/rule");
        }
        catch (Exception e) {
            throw new Exception("Could not connect to the rules database", e);
        }
        logger.info(this.persistenceRemoteObject.countRulePackages() + " rule packages stored in the database");
        List<String> ruleEngineInstances = this.persistenceRemoteObject.getRuleEngineInstancesToManage();
        for (String instanceName : ruleEngineInstances) {
            this.droolsManagerFactory.getManager(instanceName);
        }
        logger.info("Rule engine manager started");
    }

    public void stop(BundleContext context) {
        logger.info("Rule engine manager stopping");
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
        logger.info("Rule engine manager stopped");
    }
}

