/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.rules.manager.service;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.drools.KnowledgeBase;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderError;
import org.drools.builder.ResourceType;
import org.drools.definition.KnowledgePackage;
import org.drools.io.ResourceFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.ow2.jasmine.rules.api.DroolsWorkingMemoryState;
import org.ow2.jasmine.rules.api.IDroolsWorkingMemory;
import org.ow2.jasmine.rules.api.IDroolsWorkingMemoryPool;
import org.ow2.jasmine.rules.manager.model.AbstractRulePackage;
import org.ow2.jasmine.rules.manager.model.IRulePackage;
import org.ow2.jasmine.rules.manager.model.textual.TextualRulePackage;
import org.ow2.jasmine.rules.manager.model.visual.LHSCodeSnippet;
import org.ow2.jasmine.rules.manager.model.visual.RHSCodeSnippet;
import org.ow2.jasmine.rules.manager.model.visual.Rule;
import org.ow2.jasmine.rules.manager.model.visual.VisualRulePackage;
import org.ow2.jasmine.rules.manager.persistence.RulePackageSLBRemote;
import org.ow2.jasmine.rules.manager.service.IDroolsManager;
import org.ow2.jasmine.rules.manager.service.RulePackageCompilationError;
import org.ow2.jasmine.rules.manager.service.RulePackageSaveReport;
import org.ow2.jasmine.rules.manager.util.jndilocator.ServiceLocator;
import org.ow2.jasmine.rules.osgi.api.IPackageAdder;
import org.ow2.jasmine.rules.osgi.impl.DrlPackageAdder;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DroolsManager
implements IDroolsManager {
    private static Log logger = LogFactory.getLog(DroolsManager.class);
    private BundleContext bundleContext;
    private ServiceReference workingMemoryPoolReference;
    private IDroolsWorkingMemoryPool droolsWorkingMemoryPool;
    private String managedWorkingMemoryName;
    private IDroolsWorkingMemory workingMemory;
    private Map<String, ServiceRegistration> activatedRulePackages = new HashMap<String, ServiceRegistration>();
    private RulePackageSLBRemote persistenceRemoteObject = null;
    private JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{TextualRulePackage.class, VisualRulePackage.class, Rule.class, LHSCodeSnippet.class, RHSCodeSnippet.class});

    public DroolsManager(String managedWorkingMemoryName, BundleContext bundleContext) throws Exception {
        logger.info((Object)("Creating a manager for the rule engine instance \"" + managedWorkingMemoryName + "\""), new Object[0]);
        this.managedWorkingMemoryName = managedWorkingMemoryName;
        this.bundleContext = bundleContext;
        try {
            this.retrieveWorkingMemoryPool();
            this.retrieveManagedWorkingMemory();
            this.retrievePersistenceRemoteObject();
            if (this.persistenceRemoteObject.countRulePackages(managedWorkingMemoryName) == 0) {
                logger.info((Object)("Rule engine \"" + managedWorkingMemoryName + "\" manager : No rule package stored, inserting the example rules"), new Object[0]);
                this.insertExamplePackages();
            }
            logger.info((Object)(this.persistenceRemoteObject.countRulePackages(managedWorkingMemoryName) + " rule packages stored for \"" + managedWorkingMemoryName + "\""), new Object[0]);
            IRulePackage[] packagesToActivate = this.persistenceRemoteObject.getRulePackages(null, null, null, managedWorkingMemoryName, null, AbstractRulePackage.ACTIVATED, null, null);
            if (packagesToActivate != null) {
                for (IRulePackage pack : packagesToActivate) {
                    logger.info((Object)("Rule engine \"" + managedWorkingMemoryName + "\" manager : Reactivating the rule package \"" + pack.getDisplayName() + "\""), new Object[0]);
                    this.activateRulePackage(pack);
                }
            }
        }
        catch (Exception e) {
            throw new Exception("Could not build a manager for \"" + managedWorkingMemoryName + "\"", e);
        }
        logger.info((Object)("Manager created for the rule engine instance \"" + managedWorkingMemoryName + "\""), new Object[0]);
    }

    @Override
    public void start() throws Exception {
        this.workingMemory.start();
    }

    @Override
    public void stop() throws Exception {
        this.workingMemory.stop();
    }

    @Override
    public DroolsWorkingMemoryState getState() {
        return this.workingMemory.getState();
    }

    @Override
    public List<String> getWorkingMemoriesNames() {
        return this.droolsWorkingMemoryPool.getWorkingMemoriesNames();
    }

    @Override
    public List<String> getDeployedPackagesNames() {
        KnowledgeBase ruleBase = this.workingMemory.getKnowledgeBase();
        if (ruleBase == null) {
            return null;
        }
        ArrayList<String> res = new ArrayList<String>();
        Collection packages = ruleBase.getKnowledgePackages();
        for (KnowledgePackage p : packages) {
            res.add(p.getName());
        }
        return res;
    }

    @Override
    public RulePackageSaveReport commitRulePackageChanges(IRulePackage rulePackage) throws Exception {
        RulePackageSaveReport report = new RulePackageSaveReport();
        if (rulePackage.getState().equals(AbstractRulePackage.ACTIVATED)) {
            try {
                if (rulePackage.getPreviousSystemName() != null) {
                    this.deactivateRulePackage(rulePackage.getPreviousSystemName());
                } else {
                    this.deactivateRulePackage(rulePackage.getSystemName());
                }
                this.activateRulePackage(rulePackage);
                rulePackage.setState(AbstractRulePackage.ACTIVATED);
                report.addSuccess("UPDATED");
            }
            catch (Exception e) {
                report.addFailure("The rule package was not updated.", "The rule engine is still running the old version of the rule package. \n" + e.getMessage(), e.getStackTrace().toString());
            }
        } else if (rulePackage.getState().equals(AbstractRulePackage.ACTIVATION_REQUESTED)) {
            try {
                this.activateRulePackage(rulePackage);
                rulePackage.setState(AbstractRulePackage.ACTIVATED);
                report.addSuccess("OPERATION_ACTIVATE");
            }
            catch (Exception e) {
                report.addFailure("The rule package was not activated.", "The rule package could not be deployed.\n" + e.getMessage(), e.getStackTrace().toString());
            }
        } else if (rulePackage.getState().equals(AbstractRulePackage.DEACTIVATION_REQUESTED)) {
            try {
                if (rulePackage.getPreviousSystemName() != null) {
                    this.deactivateRulePackage(rulePackage.getPreviousSystemName());
                } else {
                    this.deactivateRulePackage(rulePackage.getSystemName());
                }
                rulePackage.setState(AbstractRulePackage.DEACTIVATED);
                report.addSuccess("OPERATION_DEACTIVATE");
            }
            catch (Exception e) {
                report.addFailure("The rule package was not deactivated.", "The rule engine is still running the rule package.\n" + e.getMessage(), e.getStackTrace().toString());
                e.printStackTrace();
            }
        }
        try {
            this.saveRulePackage(rulePackage);
            report.addSuccess("OPERATION_SAVE");
        }
        catch (Exception e) {
            e.printStackTrace();
            report.addFailure("The rule package was not saved", e.getMessage(), e.getStackTrace().toString());
        }
        return report;
    }

    @Override
    public void deleteRulePackage(IRulePackage rulePackage) throws Exception {
        if (this.persistenceRemoteObject == null) {
            this.retrievePersistenceRemoteObject();
        }
        if (rulePackage.getState().equals(AbstractRulePackage.ACTIVATED)) {
            if (rulePackage.getPreviousSystemName() != null) {
                this.deactivateRulePackage(rulePackage.getPreviousSystemName());
            } else {
                this.deactivateRulePackage(rulePackage.getSystemName());
            }
        }
        this.persistenceRemoteObject.deleteRulePackage(rulePackage);
    }

    @Override
    public List<RulePackageCompilationError> checkCompilation(IRulePackage rulePackage) throws Exception {
        if (this.workingMemory == null) {
            this.retrieveManagedWorkingMemory();
        }
        KnowledgeBuilder builder = this.workingMemory.newKnowledgeBuilder();
        StringReader drlFileReader = new StringReader(rulePackage.getDrlSource());
        try {
            builder.add(ResourceFactory.newReaderResource((Reader)drlFileReader), ResourceType.DRL);
        }
        catch (Exception e) {
            // empty catch block
        }
        ((Reader)drlFileReader).close();
        ArrayList<RulePackageCompilationError> res = new ArrayList<RulePackageCompilationError>();
        for (KnowledgeBuilderError error : builder.getErrors()) {
            res.add(new RulePackageCompilationError(error.getMessage()));
        }
        return res;
    }

    @Override
    public IRulePackage getRulePackage(String systemName) throws Exception {
        if (this.persistenceRemoteObject == null) {
            this.retrievePersistenceRemoteObject();
        }
        IRulePackage[] res = this.persistenceRemoteObject.getRulePackages(null, systemName, null, this.managedWorkingMemoryName, null, null, null, 1);
        return res[0];
    }

    @Override
    public IRulePackage[] getRulePackages() throws Exception {
        if (this.persistenceRemoteObject == null) {
            this.retrievePersistenceRemoteObject();
        }
        return this.persistenceRemoteObject.getRulePackages(null, null, null, this.managedWorkingMemoryName, null, null, null, 1000);
    }

    @Override
    public void saveRulePackage(IRulePackage rulePackage) throws Exception {
        if (this.persistenceRemoteObject == null) {
            this.retrievePersistenceRemoteObject();
        }
        this.persistenceRemoteObject.saveRulePackage(rulePackage);
    }

    @Override
    public Boolean checkNameAvailability(String systemName) throws Exception {
        if (this.persistenceRemoteObject == null) {
            this.retrievePersistenceRemoteObject();
        }
        return this.persistenceRemoteObject.checkNameAvailability(systemName, this.managedWorkingMemoryName);
    }

    @Override
    public String exportRulePackageToXML(IRulePackage rulePackage) throws Exception {
        Marshaller marshaller = this.jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        StringWriter resWriter = new StringWriter();
        if (rulePackage instanceof TextualRulePackage) {
            marshaller.marshal((Object)((TextualRulePackage)rulePackage), (Writer)resWriter);
        } else if (rulePackage instanceof VisualRulePackage) {
            marshaller.marshal((Object)((VisualRulePackage)rulePackage), (Writer)resWriter);
        }
        return resWriter.toString();
    }

    @Override
    public IRulePackage importRulePackageFromXML(String serializedRulePackage) throws Exception {
        Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
        StringReader serializedRulePackageReader = new StringReader(serializedRulePackage);
        return (IRulePackage)unmarshaller.unmarshal((Reader)serializedRulePackageReader);
    }

    private void retrieveWorkingMemoryPool() throws Exception {
        try {
            this.workingMemoryPoolReference = this.bundleContext.getServiceReference(IDroolsWorkingMemoryPool.class.getName());
        }
        catch (Exception e) {
            throw new Exception("Could not retrieve the working memory pool service reference", e);
        }
        try {
            this.droolsWorkingMemoryPool = (IDroolsWorkingMemoryPool)this.bundleContext.getService(this.workingMemoryPoolReference);
        }
        catch (Exception e) {
            throw new Exception("Could not retrieve working memory pool from the service reference", e);
        }
    }

    private void retrieveManagedWorkingMemory() throws Exception {
        try {
            this.workingMemory = this.droolsWorkingMemoryPool.getOrCreate(this.managedWorkingMemoryName);
        }
        catch (Exception e) {
            throw new Exception("Could not retrieve the working memory \"" + this.managedWorkingMemoryName + "\"", e);
        }
    }

    private void retrievePersistenceRemoteObject() throws Exception {
        try {
            this.persistenceRemoteObject = (RulePackageSLBRemote)ServiceLocator.getInstance().getRemoteObject("db-ejb/rule");
        }
        catch (Exception e) {
            throw new Exception("Could not connect to the rules database", e);
        }
    }

    private void activateRulePackage(IRulePackage rulePackage) throws Exception {
        HashMap globals = new HashMap();
        try {
            ServiceRegistration packageAdderRegistration = this.bundleContext.registerService(IPackageAdder.class.getName(), (Object)new DrlPackageAdder(this.bundleContext.getBundle(), globals, this.managedWorkingMemoryName, rulePackage.getSystemName(), rulePackage.getDrlSource()), null);
            this.activatedRulePackages.put(rulePackage.getSystemName(), packageAdderRegistration);
        }
        catch (Exception e) {
            throw new Exception("Could not activate the rule package", e);
        }
    }

    private void deactivateRulePackage(String rulePackageSystemName) throws Exception {
        ServiceRegistration reg = this.activatedRulePackages.get(rulePackageSystemName);
        if (reg == null) {
            throw new Exception("The package \"" + rulePackageSystemName + "\" was " + " not found in the activated rule packages registry.");
        }
        try {
            reg.unregister();
            this.activatedRulePackages.remove(rulePackageSystemName);
        }
        catch (Exception e) {
            throw new Exception("Could not deactivate the rule package", e);
        }
    }

    private void insertExamplePackages() throws Exception {
        ArrayList<TextualRulePackage> exampleRulePackages = new ArrayList<TextualRulePackage>();
        TextualRulePackage rp1 = new TextualRulePackage();
        rp1.displayName = "Print Events";
        rp1.ruleEngineInstanceName = this.managedWorkingMemoryName;
        rp1.systemName = "org.ow2.jasmine.rules.packages.PrintEvents";
        rp1.description = "This is an example rule package with only one rule that matches every JasmineEventEB inserted and prints it in the console.";
        rp1.state = TextualRulePackage.DEACTIVATED;
        rp1.content = "/**\n* JASMINe\n* Copyright (C) 2009 Bull S.A.S.\n* Contact: jasmine@ow2.org\n*\n* This library is free software; you can redistribute it and/or\n* modify it under the terms of the GNU Lesser General Public\n* License as published by the Free Software Foundation; either\n* version 2.1 of the License, or any later version.\n*\n* This library is distributed in the hope that it will be useful,\n* but WITHOUT ANY WARRANTY; without even the implied warranty of\n* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n* Lesser General Public License for more details.\n*\n* You should have received a copy of the GNU Lesser General Public\n* License along with this library; if not, write to the Free Software\n* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307\n* USA\n*/\npackage org.ow2.jasmine.rules.packages.PrintEvents\n\nimport org.ow2.jasmine.event.beans.JasmineEventEB;\n\nrule \"Print each event\"\n    no-loop false\n    when\n        $event : JasmineEventEB()\n    then\n           System.out.println(\"=============================================\");\n           System.out.println(\"PrintEvents matched this event:              \");\n           System.out.println($event.toString());\n           System.out.println(\"=============================================\");\n           retract($event);\nend";
        exampleRulePackages.add(rp1);
        TextualRulePackage rp2 = new TextualRulePackage();
        rp2.displayName = "Insert Jasmine Event In Notification Database";
        rp2.systemName = "org.ow2.jasmine.rules.packages.InsertJasmineEventInNotificationDatabase";
        rp2.ruleEngineInstanceName = this.managedWorkingMemoryName;
        rp2.description = "This is an example rule package with only one rule that matches every JasmineEventEB inserted and generates a notification inserted in the notifications database.";
        rp2.state = TextualRulePackage.DEACTIVATED;
        rp2.content = "/**\n* JASMINe\n* Copyright (C) 2009 Bull S.A.S.\n* Contact: jasmine@ow2.org\n*\n* This library is free software; you can redistribute it and/or\n* modify it under the terms of the GNU Lesser General Public\n* License as published by the Free Software Foundation; either\n* version 2.1 of the License, or any later version.\n*\n* This library is distributed in the hope that it will be useful,\n* but WITHOUT ANY WARRANTY; without even the implied warranty of\n* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n* Lesser General Public License for more details.\n*\n* You should have received a copy of the GNU Lesser General Public\n* License along with this library; if not, write to the Free Software\n* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307\n* USA\n*/\npackage org.ow2.jasmine.rules.packages.InsertJasmineEventInNotificationDatabase\n\nimport java.io.Serializable;\nimport java.util.Date;\n\nimport org.objectweb.jasmine.rules.dispatcher.NotificationDispatcher;\nimport org.ow2.jasmine.event.beans.JasmineEventEB;\nimport org.ow2.jasmine.event.beans.JasmineEventNotification;\n\nrule \"Insert in database each event\"\n    no-loop false\n    when\n        $event : JasmineEventEB()\n    then\n        // Create a new notification\n        // notification id is auto-generated\n        JasmineEventNotification notification = new JasmineEventNotification();\n        \n        // Set the notification message\n        notification.setMessage($event.getProbe());\n        // Set the notification date\n        notification.setDate(new Date());\n        // Set the notification level\n        notification.setLevel(\"Info\");\n        // set the notification status\n        notification.setStatus(false);\n        // Set the rule\n        // The rules are configured in notification-config.xml file\n        notification.setRule(\"InsertJasmineEventInNotificationDatabase\");\n        \n        // Add some details to the notification\n        notification.addDetail(\"domain\", $event.getDomain());\n        notification.addDetail(\"server\", $event.getServer());\n        notification.addDetail(\"timestamp\", $event.getTimestamp().toString());\n        \n        // Send the notification to the dispatcher\n        NotificationDispatcher.dispatchEvent(NotificationDispatcher.EventAction.SAVE_IN_DATABASE, notification);\n\t\t   \n        retract($event);\nend";
        exampleRulePackages.add(rp2);
        TextualRulePackage rp3 = new TextualRulePackage();
        rp3.displayName = "Send Jasmine Event As Notification Mail";
        rp3.systemName = "org.ow2.jasmine.rules.packages.SendJasmineEventAsNotificationMail";
        rp3.ruleEngineInstanceName = this.managedWorkingMemoryName;
        rp3.description = "This is an example rule package with only one rule that matches every JasmineEventEB inserted and generates a mail notification.";
        rp3.state = TextualRulePackage.DEACTIVATED;
        rp3.content = "/**\n* JASMINe\n* Copyright (C) 2009 Bull S.A.S.\n* Contact: jasmine@ow2.org\n*\n* This library is free software; you can redistribute it and/or\n* modify it under the terms of the GNU Lesser General Public\n* License as published by the Free Software Foundation; either\n* version 2.1 of the License, or any later version.\n*\n* This library is distributed in the hope that it will be useful,\n* but WITHOUT ANY WARRANTY; without even the implied warranty of\n* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n* Lesser General Public License for more details.\n*\n* You should have received a copy of the GNU Lesser General Public\n* License along with this library; if not, write to the Free Software\n* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307\n* USA\n*/\npackage org.ow2.jasmine.rules.packages.SendJasmineEventAsNotificationMail\n\nimport java.io.Serializable;\nimport java.util.Date;\n\nimport org.objectweb.jasmine.rules.dispatcher.NotificationDispatcher;\nimport org.ow2.jasmine.event.beans.JasmineEventEB;\nimport org.ow2.jasmine.event.beans.JasmineEventNotification;\n\nrule \"Send each event as a mail\"\n    no-loop false\n    when\n        $event : JasmineEventEB()\n    then\n        // Create a new notification\n        // notification id is auto-generated\n        JasmineEventNotification notification = new JasmineEventNotification();\n        \n        // Set the notification message\n        notification.setMessage($event.getProbe());\n        // Set the notification date\n        notification.setDate(new Date());\n        // Set the notification level\n        notification.setLevel(\"Info\");\n        // Set the notification status\n        notification.setStatus(false);\n        // Set the rule\n        // The rules are configured in notification-config.xml file\n        notification.setRule(\"SendJasmineEventAsNotificationMail\");\n        \n        // Add some details to the notification\n        notification.addDetail(\"domain\", $event.getDomain());\n        notification.addDetail(\"server\", $event.getServer());\n        notification.addDetail(\"timestamp\", $event.getTimestamp().toString());\n        \n        // Send the notification to the dispatcher\n        NotificationDispatcher.dispatchEvent(NotificationDispatcher.EventAction.SEND_MAIL, notification,\"jasmine@ow2.org\",\"to@address.com\");\n\nend";
        exampleRulePackages.add(rp3);
        TextualRulePackage rp4 = new TextualRulePackage();
        rp4.displayName = "Export Jasmine Event As JMX Notification";
        rp4.systemName = "org.ow2.jasmine.rules.packages.ExportJasmineEventAsJMXNotification";
        rp4.ruleEngineInstanceName = this.managedWorkingMemoryName;
        rp4.description = "Exports each matched JASMINe event as a JMX notification.";
        rp4.state = TextualRulePackage.DEACTIVATED;
        rp4.content = "/**\n* JASMINe\n* Copyright (C) 2009 Bull S.A.S.\n* Contact: jasmine@ow2.org\n*\n* This library is free software; you can redistribute it and/or\n* modify it under the terms of the GNU Lesser General Public\n* License as published by the Free Software Foundation; either\n* version 2.1 of the License, or any later version.\n*\n* This library is distributed in the hope that it will be useful,\n* but WITHOUT ANY WARRANTY; without even the implied warranty of\n* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n* Lesser General Public License for more details.\n*\n* You should have received a copy of the GNU Lesser General Public\n* License along with this library; if not, write to the Free Software\n* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307\n* USA\n*/\npackage org.ow2.jasmine.rules.packages.ExportJasmineEventAsJMXNotification\n\nimport java.io.Serializable;\nimport java.util.Date;\n\nimport org.objectweb.jasmine.rules.dispatcher.NotificationDispatcher;\nimport org.ow2.jasmine.event.beans.JasmineEventEB;\nimport org.ow2.jasmine.event.beans.JasmineEventNotification;\n\nrule \"export each event as a JMX notification\"\n    no-loop false\n    when\n        $event : JasmineEventEB()\n    then\n        // Create a new notification\n        // notification id is auto-generated\n        JasmineEventNotification notification = new JasmineEventNotification();\n        \n        // Set the notification message\n        notification.setMessage($event.getProbe());\n        // Set the notification date\n        notification.setDate(new Date());\n        // Set the notification level\n        notification.setLevel(\"Info\");\n        // Set the notification status\n        notification.setStatus(false);\n        // Set the rule\n        // The rules are configured in notification-config.xml file\n        notification.setRule(\"ExportJasmineEventAsJMXNotification\");\n        \n        // Add some details to the notification\n        notification.addDetail(\"domain\", $event.getDomain());\n        notification.addDetail(\"server\", $event.getServer());\n        notification.addDetail(\"timestamp\", $event.getTimestamp().toString());\n        \n        // Send the notification to the dispatcher\n        NotificationDispatcher.dispatchEvent(NotificationDispatcher.EventAction.JMX_EXPORT, notification);\n\nend";
        exampleRulePackages.add(rp4);
        for (IRulePackage iRulePackage : exampleRulePackages) {
            this.saveRulePackage(iRulePackage);
        }
    }
}

