/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentMap;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicReference;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.MuleRuntimeException;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.ThreadSafeAccess;
import org.mule.umo.UMOExceptionPayload;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.umo.transformer.TransformerException;
import org.mule.util.StringUtils;
import org.mule.util.UUID;

public abstract class AbstractMessageAdapter
implements UMOMessageAdapter,
ThreadSafeAccess {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected ConcurrentMap properties = new ConcurrentHashMap();
    protected ConcurrentMap attachments = new ConcurrentHashMap();
    protected String encoding = MuleManager.getConfiguration().getEncoding();
    public static final boolean DEFAULT_FAILFAST = false;
    protected UMOExceptionPayload exceptionPayload;
    protected String id = UUID.getUUID();
    private transient AtomicReference ownerThread = null;
    private transient AtomicBoolean mutable = null;
    public static final boolean WRITE = true;
    public static final boolean READ = false;

    protected AbstractMessageAdapter() {
    }

    protected AbstractMessageAdapter(UMOMessageAdapter template) {
        if (null != template) {
            Iterator propertyNames = template.getPropertyNames().iterator();
            while (propertyNames.hasNext()) {
                String key = (String)propertyNames.next();
                try {
                    this.setProperty(key, template.getProperty(key));
                }
                catch (Exception e) {
                    throw new MuleRuntimeException(CoreMessages.failedToReadPayload(), (Throwable)e);
                }
            }
            Iterator attachmentNames = template.getAttachmentNames().iterator();
            while (attachmentNames.hasNext()) {
                String key = (String)attachmentNames.next();
                try {
                    this.addAttachment(key, template.getAttachment(key));
                }
                catch (Exception e) {
                    throw new MuleRuntimeException(CoreMessages.failedToReadPayload(), (Throwable)e);
                }
            }
            this.encoding = template.getEncoding();
            this.exceptionPayload = template.getExceptionPayload();
            this.id = template.getUniqueId();
        }
    }

    public String toString() {
        this.assertAccess(false);
        StringBuffer buf = new StringBuffer(120);
        buf.append(this.getClass().getName());
        buf.append("/" + super.toString());
        buf.append('{');
        buf.append("id=").append(this.getUniqueId());
        buf.append(", payload=").append(this.getPayload().getClass().getName());
        buf.append(", correlationId=").append(this.getCorrelationId());
        buf.append(", correlationGroup=").append(this.getCorrelationGroupSize());
        buf.append(", correlationSeq=").append(this.getCorrelationSequence());
        buf.append(", encoding=").append(this.getEncoding());
        buf.append(", exceptionPayload=").append(this.exceptionPayload);
        buf.append(", properties=").append(org.mule.util.MapUtils.toString((Map)this.properties, (boolean)true));
        buf.append('}');
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProperties(Map props) {
        this.assertAccess(true);
        if (props != null) {
            Map map = props;
            synchronized (map) {
                Iterator iter = props.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    this.setProperty((String)entry.getKey(), entry.getValue());
                }
            }
        }
    }

    public void clearProperties() {
        this.assertAccess(true);
        this.properties.clear();
    }

    public Object removeProperty(String key) {
        this.assertAccess(true);
        return this.properties.remove((Object)key);
    }

    public Object getProperty(String key) {
        this.assertAccess(false);
        return this.properties.get((Object)key);
    }

    public Set getPropertyNames() {
        this.assertAccess(false);
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    public void setProperty(String key, Object value) {
        this.assertAccess(true);
        if (key != null) {
            if (value != null) {
                this.properties.put((Object)key, value);
            } else {
                this.logger.warn((Object)("setProperty(key, value) called with null value; removing key: " + key + "; please report the following stack trace to dev@mule.codehaus.org."), new Throwable());
                this.properties.remove((Object)key);
            }
        } else {
            this.logger.warn((Object)("setProperty(key, value) ignored because of null key for object: " + value + "; please report the following stack trace to dev@mule.codehaus.org."), new Throwable());
        }
    }

    public String getUniqueId() {
        this.assertAccess(false);
        return this.id;
    }

    public Object getProperty(String name, Object defaultValue) {
        this.assertAccess(false);
        return org.mule.util.MapUtils.getObject((Map)this.properties, (Object)name, (Object)defaultValue);
    }

    public int getIntProperty(String name, int defaultValue) {
        this.assertAccess(false);
        return org.mule.util.MapUtils.getIntValue((Map)this.properties, (Object)name, (int)defaultValue);
    }

    public long getLongProperty(String name, long defaultValue) {
        this.assertAccess(false);
        return org.mule.util.MapUtils.getLongValue((Map)this.properties, (Object)name, (long)defaultValue);
    }

    public double getDoubleProperty(String name, double defaultValue) {
        this.assertAccess(false);
        return org.mule.util.MapUtils.getDoubleValue((Map)this.properties, (Object)name, (double)defaultValue);
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        this.assertAccess(false);
        return org.mule.util.MapUtils.getBooleanValue((Map)this.properties, (Object)name, (boolean)defaultValue);
    }

    public String getStringProperty(String name, String defaultValue) {
        this.assertAccess(false);
        return org.mule.util.MapUtils.getString((Map)this.properties, (Object)name, (String)defaultValue);
    }

    public void setBooleanProperty(String name, boolean value) {
        this.assertAccess(true);
        this.setProperty(name, value);
    }

    public void setIntProperty(String name, int value) {
        this.assertAccess(true);
        this.setProperty(name, new Integer(value));
    }

    public void setLongProperty(String name, long value) {
        this.assertAccess(true);
        this.setProperty(name, new Long(value));
    }

    public void setDoubleProperty(String name, double value) {
        this.assertAccess(true);
        this.setProperty(name, new Double(value));
    }

    public void setStringProperty(String name, String value) {
        this.assertAccess(true);
        this.setProperty(name, value);
    }

    public Object getReplyTo() {
        this.assertAccess(false);
        return this.getProperty("MULE_REPLYTO");
    }

    public void setReplyTo(Object replyTo) {
        this.assertAccess(true);
        if (replyTo != null) {
            this.setProperty("MULE_REPLYTO", replyTo);
        } else {
            this.removeProperty("MULE_REPLYTO");
        }
    }

    public String getCorrelationId() {
        this.assertAccess(false);
        return (String)this.getProperty("MULE_CORRELATION_ID");
    }

    public void setCorrelationId(String correlationId) {
        this.assertAccess(true);
        if (StringUtils.isNotBlank((String)correlationId)) {
            this.setProperty("MULE_CORRELATION_ID", correlationId);
        } else {
            this.removeProperty("MULE_CORRELATION_ID");
        }
    }

    public int getCorrelationSequence() {
        this.assertAccess(false);
        return this.getIntProperty("MULE_CORRELATION_SEQUENCE", -1);
    }

    public void setCorrelationSequence(int sequence) {
        this.assertAccess(true);
        this.setIntProperty("MULE_CORRELATION_SEQUENCE", sequence);
    }

    public int getCorrelationGroupSize() {
        this.assertAccess(false);
        return this.getIntProperty("MULE_CORRELATION_GROUP_SIZE", -1);
    }

    public void setCorrelationGroupSize(int size) {
        this.assertAccess(true);
        this.setIntProperty("MULE_CORRELATION_GROUP_SIZE", size);
    }

    public UMOExceptionPayload getExceptionPayload() {
        this.assertAccess(false);
        return this.exceptionPayload;
    }

    public void setExceptionPayload(UMOExceptionPayload payload) {
        this.assertAccess(true);
        this.exceptionPayload = payload;
    }

    public void addAttachment(String name, DataHandler dataHandler) throws Exception {
        this.assertAccess(true);
        this.attachments.put((Object)name, (Object)dataHandler);
    }

    public void removeAttachment(String name) throws Exception {
        this.assertAccess(true);
        this.attachments.remove((Object)name);
    }

    public DataHandler getAttachment(String name) {
        this.assertAccess(false);
        return (DataHandler)this.attachments.get((Object)name);
    }

    public Set getAttachmentNames() {
        this.assertAccess(false);
        return Collections.unmodifiableSet(this.attachments.keySet());
    }

    public String getEncoding() {
        this.assertAccess(false);
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.assertAccess(true);
        this.encoding = encoding;
    }

    public final String getPayloadAsString() throws Exception {
        this.assertAccess(false);
        return this.getPayloadAsString(this.getEncoding());
    }

    protected byte[] convertToBytes(Object object) throws TransformerException, UnsupportedEncodingException {
        this.assertAccess(false);
        if (object instanceof String) {
            return object.toString().getBytes(this.getEncoding());
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof Serializable) {
            try {
                return SerializationUtils.serialize((Serializable)((Serializable)object));
            }
            catch (Exception e) {
                throw new TransformerException(CoreMessages.transformFailed((String)object.getClass().getName(), (String)"byte[]"), (Throwable)e);
            }
        }
        throw new TransformerException(CoreMessages.transformOnObjectNotOfSpecifiedType((String)object.getClass().getName(), (Object)("byte[] or " + Serializable.class.getName())));
    }

    public void assertAccess(boolean write) {
        this.initAccessControl();
        this.setOwner();
        this.checkMutable(write);
    }

    private void setOwner() {
        if (null == this.ownerThread.get()) {
            this.ownerThread.compareAndSet(null, (Object)Thread.currentThread());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkMutable(boolean write) {
        Thread currentThread = Thread.currentThread();
        if (currentThread.equals(this.ownerThread.get())) {
            if (!write || this.mutable.get()) return;
            if (!this.isDisabled()) throw this.newException("Cannot write to immutable message");
            this.logger.warn((Object)"Writing to immutable message (exception disabled)");
            return;
        } else if (write) {
            if (!this.isDisabled()) throw this.newException("Only owner thread can write to message: " + this.ownerThread.get() + "/" + Thread.currentThread());
            this.logger.warn((Object)"Non-owner writing to message (exception disabled)");
            return;
        } else {
            this.mutable.set(false);
        }
    }

    protected IllegalStateException newException(String message) {
        IllegalStateException exception = new IllegalStateException(message);
        this.logger.warn((Object)"Message access violation", (Throwable)exception);
        return exception;
    }

    protected boolean isDisabled() {
        return MapUtils.getBooleanValue((Map)System.getProperties(), (Object)"org.mule.disable.threadsafemessages", (boolean)true);
    }

    private synchronized void initAccessControl() {
        if (null == this.ownerThread) {
            this.ownerThread = new AtomicReference();
        }
        if (null == this.mutable) {
            this.mutable = new AtomicBoolean(true);
        }
    }

    public synchronized void resetAccessControl() {
        this.assertAccess(true);
        this.ownerThread.set(null);
        this.mutable.set(true);
    }

    public ThreadSafeAccess newThreadCopy() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"The newThreadCopy method in AbstractMessageAdapter is being used directly. This code may be susceptible to 'scribbling' issues with messages. Please consider implementing the ThreadSafeAccess interface in the message adapter.");
        }
        return this;
    }
}

