/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers;

import edu.emory.mathcs.backport.java.util.concurrent.CountDownLatch;
import java.util.Iterator;
import java.util.List;
import javax.resource.spi.work.Work;
import org.mule.config.ThreadingProfile;
import org.mule.providers.AbstractPollingMessageReceiver;
import org.mule.transaction.TransactionCallback;
import org.mule.transaction.TransactionTemplate;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;

public abstract class TransactedPollingMessageReceiver
extends AbstractPollingMessageReceiver {
    private boolean receiveMessagesInTransaction = true;
    private boolean useMultipleReceivers = true;

    public TransactedPollingMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint) throws InitialisationException {
        super(connector, component, endpoint);
        this.setReceiveMessagesInTransaction(endpoint.getTransactionConfig().isConfigured());
    }

    public TransactedPollingMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint, long frequency) throws InitialisationException {
        this(connector, component, endpoint);
        this.setFrequency(frequency);
    }

    public boolean isReceiveMessagesInTransaction() {
        return this.receiveMessagesInTransaction;
    }

    public void setReceiveMessagesInTransaction(boolean useTx) {
        this.receiveMessagesInTransaction = useTx;
    }

    public boolean isUseMultipleTransactedReceivers() {
        return this.useMultipleReceivers;
    }

    public void setUseMultipleTransactedReceivers(boolean useMultiple) {
        this.useMultipleReceivers = useMultiple;
    }

    public void doStart() throws UMOException {
        this.setUseMultipleTransactedReceivers(this.connector.isCreateMultipleTransactedReceivers());
        ThreadingProfile tp = this.connector.getReceiverThreadingProfile();
        int numReceiversToStart = 1;
        if (this.isReceiveMessagesInTransaction() && this.isUseMultipleTransactedReceivers() && tp.isDoThreading()) {
            numReceiversToStart = this.connector.getNumberOfConcurrentTransactedReceivers();
        }
        for (int i = 0; i < numReceiversToStart; ++i) {
            super.doStart();
        }
    }

    public void poll() throws Exception {
        TransactionTemplate tt = new TransactionTemplate(this.endpoint.getTransactionConfig(), this.connector.getExceptionListener());
        if (this.isReceiveMessagesInTransaction()) {
            TransactionCallback cb = new TransactionCallback(){

                public Object doInTransaction() throws Exception {
                    List messages = TransactedPollingMessageReceiver.this.getMessages();
                    if (messages != null && messages.size() > 0) {
                        Iterator it = messages.iterator();
                        while (it.hasNext()) {
                            TransactedPollingMessageReceiver.this.processMessage(it.next());
                        }
                    }
                    return null;
                }
            };
            tt.execute(cb);
        } else {
            List messages = this.getMessages();
            if (messages != null && messages.size() > 0) {
                CountDownLatch countdown = new CountDownLatch(messages.size());
                Iterator it = messages.iterator();
                while (it.hasNext()) {
                    try {
                        this.getWorkManager().scheduleWork((Work)new MessageProcessorWorker(tt, countdown, it.next()));
                    }
                    catch (Exception e) {
                        countdown.countDown();
                        throw e;
                    }
                }
                countdown.await();
            }
        }
    }

    protected abstract List getMessages() throws Exception;

    protected abstract void processMessage(Object var1) throws Exception;

    protected class MessageProcessorWorker
    implements Work,
    TransactionCallback {
        private final TransactionTemplate tt;
        private final Object message;
        private final CountDownLatch latch;

        public MessageProcessorWorker(TransactionTemplate tt, CountDownLatch latch, Object message) {
            this.tt = tt;
            this.message = message;
            this.latch = latch;
        }

        public void release() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.tt.execute((TransactionCallback)this);
            }
            catch (Exception e) {
                TransactedPollingMessageReceiver.this.handleException(e);
            }
            finally {
                this.latch.countDown();
            }
        }

        public Object doInTransaction() throws Exception {
            TransactedPollingMessageReceiver.this.processMessage(this.message);
            return null;
        }
    }
}

