/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms;

import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.mule.impl.model.AbstractComponent;
import org.mule.providers.DefaultReplyToHandler;
import org.mule.providers.jms.JmsConnector;
import org.mule.providers.jms.JmsMessageUtils;
import org.mule.providers.jms.i18n.JmsMessages;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.provider.DispatchException;
import org.mule.umo.transformer.UMOTransformer;

public class JmsReplyToHandler
extends DefaultReplyToHandler {
    private final JmsConnector connector;

    public JmsReplyToHandler(JmsConnector connector, UMOTransformer transformer) {
        super(transformer);
        this.connector = connector;
    }

    public void processReplyTo(UMOEvent event, UMOMessage returnMessage, Object replyTo) throws UMOException {
        Destination replyToDestination = null;
        MessageProducer replyToProducer = null;
        Session session = null;
        try {
            if (replyTo instanceof Destination) {
                replyToDestination = (Destination)replyTo;
            }
            if (replyToDestination == null) {
                super.processReplyTo(event, returnMessage, replyTo);
                return;
            }
            Object payload = returnMessage.getPayload();
            if (this.getTransformer() != null) {
                this.getTransformer().setEndpoint((UMOImmutableEndpoint)this.getEndpoint(event, "jms://temporary?connector=" + this.connector.getName()));
                if (this.getTransformer().isSourceTypeSupported(payload.getClass())) {
                    payload = this.getTransformer().transform(payload);
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Transformer for replyTo Handler: " + this.getTransformer().toString() + " does not support source type: " + payload.getClass() + ". Not doing a transform"));
                }
            }
            boolean topic = this.connector.getTopicResolver().isTopic(replyToDestination);
            session = this.connector.getSession(false, topic);
            Message replyToMessage = JmsMessageUtils.toMessage(payload, session);
            replyToMessage.setJMSReplyTo(null);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Sending jms reply to: " + replyToDestination + "(" + replyToDestination.getClass().getName() + ")"));
            }
            replyToProducer = this.connector.getJmsSupport().createProducer(session, replyToDestination, topic);
            UMOMessage eventMsg = event.getMessage();
            String ttlString = (String)eventMsg.removeProperty("timeToLive");
            String priorityString = (String)eventMsg.removeProperty("priority");
            String persistentDeliveryString = (String)eventMsg.removeProperty("persistentDelivery");
            if (ttlString == null && priorityString == null && persistentDeliveryString == null) {
                this.connector.getJmsSupport().send(replyToProducer, replyToMessage, topic);
            } else {
                long ttl = 0L;
                int priority = 4;
                boolean persistent = true;
                if (ttlString != null) {
                    ttl = Long.parseLong(ttlString);
                }
                if (priorityString != null) {
                    priority = Integer.parseInt(priorityString);
                }
                persistent = persistentDeliveryString != null ? Boolean.valueOf(persistentDeliveryString).booleanValue() : this.connector.isPersistentDelivery();
                this.connector.getJmsSupport().send(replyToProducer, replyToMessage, persistent, priority, ttl, topic);
            }
            logger.info((Object)("Reply Message sent to: " + replyToDestination));
            ((AbstractComponent)event.getComponent()).getStatistics().incSentReplyToEvent();
            this.connector.closeQuietly(replyToProducer);
            this.connector.closeQuietly(session);
        }
        catch (Exception e) {
            throw new DispatchException(JmsMessages.failedToCreateAndDispatchResponse((Object)replyToDestination), returnMessage, null, (Throwable)e);
        }
        finally {
            this.connector.closeQuietly(replyToProducer);
            this.connector.closeQuietly(session);
        }
    }
}

