/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eventswitch.endpoints;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.ow2.jasmine.event.messages.JasmineEvent;

public class MBeanCmdDispatcher {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private static final String nonProbeFields = ";date;time;server;domain;mbean;name;sname;";

    private static int getVersion(String header, String format) throws UnsupportedOperationException {
        try {
            if (header.indexOf(format) == 0) {
                return Integer.parseInt(header.substring(format.length()));
            }
            if (header.indexOf("time;date;server;domain;mbean;") == 0) {
                return 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new UnsupportedOperationException("Header not recognized: " + header);
    }

    public JasmineEvent receivedMBeanCmdMessage(String msg) {
        String[] message = msg.split("\n");
        int version = MBeanCmdDispatcher.getVersion(message[0], "mbeancmd_values_v");
        if (version < 0 || version > 1) {
            String error = "Unknown MBeanCmd message version: " + version;
            this.logger.warning(error);
            throw new UnsupportedOperationException(error);
        }
        String[] msgHeader = message[1].split(";");
        String messageContents = message[2];
        ArrayList<String> msgBody = new ArrayList<String>(msgHeader.length);
        while (true) {
            int currentComma;
            if ((currentComma = messageContents.indexOf(59)) == -1) break;
            msgBody.add(messageContents.substring(0, currentComma));
            messageContents = messageContents.substring(currentComma + 1);
        }
        msgBody.add(messageContents);
        if (msgBody.size() != msgHeader.length) {
            String error = "The received message is invalid: its header and body don't have the same number of fields (" + msgHeader.length + " versus " + msgBody.size() + ")";
            this.logger.warning(error);
            throw new IllegalArgumentException(error);
        }
        TreeMap<String, Integer> header = new TreeMap<String, Integer>();
        LinkedList<String> probes = new LinkedList<String>();
        for (int i = 0; i < msgHeader.length; ++i) {
            if (msgHeader[i].length() <= 0) continue;
            header.put(msgHeader[i], i);
            if (nonProbeFields.contains(";" + msgHeader[i] + ";")) continue;
            probes.add(msgHeader[i]);
        }
        JasmineEvent event = new JasmineEvent();
        Date timestamp = new Date(Long.parseLong((String)msgBody.get((Integer)header.get("time"))));
        event.setDomain((String)msgBody.get((Integer)header.get("domain")));
        event.setServer((String)msgBody.get((Integer)header.get("server")));
        String mbean = (String)msgBody.get((Integer)header.get("mbean")) + ":";
        String sname = (String)msgBody.get((Integer)header.get("sname"));
        for (String s : probes) {
            event.addEvent("mbeancmd", mbean + s, (String)msgBody.get((Integer)header.get(s)), timestamp, sname);
        }
        return event;
    }

    public JasmineEvent receivedMBeanCmdMessage(byte[] msg) {
        return this.receivedMBeanCmdMessage(new String(msg));
    }
}

