/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eventswitch.endpoints;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.naming.NamingException;
import org.ow2.jasmine.event.messages.JasmineEventNotificationMail;
import org.ow2.jasmine.monitoring.eventswitch.endpoints.MuleEJB3Wrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailSenderWrapper
extends MuleEJB3Wrapper<Session> {
    public MailSenderWrapper() {
        super(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendJasmineEventNotification(JasmineEventNotificationMail notificationEventMail) {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(MailSenderWrapper.class.getClassLoader());
        try {
            MimeMessage message = new MimeMessage((Session)this.getBean());
            if (notificationEventMail.getFrom() != null) {
                message.setFrom((Address)new InternetAddress(notificationEventMail.getFrom()));
            }
            InternetAddress[] toRecipients = new InternetAddress[]{new InternetAddress(notificationEventMail.getTo())};
            message.setRecipients(Message.RecipientType.TO, (Address[])toRecipients);
            if (notificationEventMail.getCc() != null) {
                InternetAddress[] ccRecipients = new InternetAddress[]{new InternetAddress(notificationEventMail.getCc())};
                message.setRecipients(Message.RecipientType.CC, (Address[])ccRecipients);
            }
            if (notificationEventMail.getBcc() != null) {
                InternetAddress[] bccRecipients = new InternetAddress[]{new InternetAddress(notificationEventMail.getBcc())};
                message.setRecipients(Message.RecipientType.BCC, (Address[])bccRecipients);
            }
            message.setSubject("[" + notificationEventMail.getLevel() + "]" + " alarm notification");
            message.setContent((Object)notificationEventMail.getMessage(), "text/plain");
            Transport.send((Message)message);
        }
        catch (MessagingException e) {
            Logger.getLogger(MailSenderWrapper.class.getName()).log(Level.WARNING, "A failure occurs when getting a message from the session and setting the different parameters :" + e.getMessage());
        }
        catch (NamingException e) {
            Logger.getLogger(MailSenderWrapper.class.getName()).log(Level.WARNING, "You have not configure the mail factory with the name specified By default, the factory's name is mailSession_1 :" + e.getMessage());
        }
        catch (IOException e) {
            Logger.getLogger(MailSenderWrapper.class.getName()).log(Level.WARNING, "You have not configure the mail factory with the name specified By default, the factory's name is mailSession_1 :" + e.getMessage());
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }
}

