/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eventswitch.manager;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.mule.umo.manager.UMOManager;
import org.ow2.jasmine.monitoring.eventswitch.endpoints.MBeanCmdWrapper;
import org.ow2.jasmine.monitoring.eventswitch.manager.EventSwitchManagerMBean;
import org.ow2.jasmine.monitoring.mbeancmd.CommandDispatcher;

public class EventSwitchManager
implements EventSwitchManagerMBean {
    private static EventSwitchManager manager = null;
    private UMOManager muleManager = null;
    private Map<String, Thread> mbeanCmdList = new HashMap<String, Thread>();

    private EventSwitchManager() {
    }

    public static EventSwitchManager getInstance() {
        if (manager == null) {
            manager = new EventSwitchManager();
        }
        return manager;
    }

    public static void deleteInstance() {
        manager = null;
    }

    public UMOManager getMuleManager() {
        return this.muleManager;
    }

    public void setMuleManager(UMOManager muleManager) {
        this.muleManager = muleManager;
    }

    public String addMBeanCmdCommand(String name, Thread thread) {
        String n = name + ":" + thread.toString();
        this.mbeanCmdList.put(n, thread);
        return n;
    }

    public void stopMBeanCmdCommand(String name) {
        this.mbeanCmdList.get(name).interrupt();
        this.mbeanCmdList.remove(name);
    }

    public void stopAllMBeanCmdCommands() {
        for (String name : this.mbeanCmdList.keySet()) {
            this.mbeanCmdList.get(name).interrupt();
        }
        this.mbeanCmdList.clear();
    }

    public String[] MBeanCmdCommandNames() {
        Set<String> s = this.mbeanCmdList.keySet();
        String[] result = new String[s.size()];
        s.toArray(result);
        return result;
    }

    public String startMBeanCmdCommand(String command) {
        final String[] args = MBeanCmdWrapper.parseCommandLine(command);
        String name = command;
        if (args.length > 0) {
            boolean jasmineOption = false;
            boolean jasmineItem = false;
            for (String arg : args) {
                if (jasmineOption) {
                    if (arg.length() <= 0) break;
                    jasmineItem = true;
                    break;
                }
                if (!arg.equals("-jasmine")) continue;
                jasmineOption = true;
            }
            if (!jasmineOption || !jasmineItem) {
                throw new IllegalArgumentException("-jasmine option not specified for the MBeanCmd container");
            }
            Thread t = new Thread(){

                public void run() {
                    CommandDispatcher.start((String[])args);
                }
            };
            name = this.addMBeanCmdCommand(command, t);
            t.start();
        }
        return name;
    }
}

