/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eventswitch.transformers;

import org.mule.transformers.AbstractTransformer;
import org.mule.umo.transformer.TransformerException;
import org.ow2.jasmine.event.beans.JasmineEventNotification;
import org.ow2.jasmine.event.beans.JasmineEventNotificationDetail;
import org.ow2.jasmine.monitoring.eventswitch.transformers.JasmineDateFormater;

public class JasmineEventNotificationToCSV
extends AbstractTransformer {
    public JasmineEventNotificationToCSV() {
        this.registerSourceType(JasmineEventNotification.class);
        this.setReturnClass(String.class);
    }

    protected Object doTransform(Object src, String encoding) throws TransformerException {
        String result = "";
        String split = ";";
        if (src instanceof JasmineEventNotification) {
            JasmineEventNotification event = (JasmineEventNotification)src;
            String formatedDate = JasmineDateFormater.getDateFormat(event.getDate());
            result = result + event.getId() + ";" + event.getLevel() + ";" + event.getMessage() + ";" + formatedDate + ";" + event.getMessage() + ";" + event.getStatus() + ";";
            if (!event.getDetails().isEmpty()) {
                for (JasmineEventNotificationDetail entry : event.getDetails()) {
                    result = result + entry.getLabel() + ":" + entry.getMessage();
                }
            }
        } else {
            throw new IllegalArgumentException("Unable to transform this source type: " + src.getClass().getName());
        }
        result = result + "\n";
        return result;
    }
}

