/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eventswitch.transformers;

import org.mule.transformers.AbstractTransformer;
import org.mule.umo.transformer.TransformerException;
import org.ow2.jasmine.event.beans.JasmineEventNotification;
import org.ow2.jasmine.event.beans.JasmineEventNotificationDetail;
import org.ow2.jasmine.monitoring.eventswitch.transformers.JasmineDateFormater;

public class JasmineEventNotificationToString
extends AbstractTransformer {
    public JasmineEventNotificationToString() {
        this.registerSourceType(JasmineEventNotification.class);
        this.setReturnClass(String.class);
    }

    protected Object doTransform(Object src, String encoding) throws TransformerException {
        String result = "";
        if (src instanceof JasmineEventNotification) {
            JasmineEventNotification event = (JasmineEventNotification)src;
            String formatedDate = JasmineDateFormater.getDateFormat(event.getDate());
            result = result + "JASMINe Event Notification object : ";
            result = result + "\n\tId:  " + event.getId() + "\n\tLevel:  " + event.getLevel() + "\n\tTime:   " + formatedDate + "\n\tMessage:  " + event.getMessage() + "\n\tStatus:  " + event.getStatus();
            if (!event.getDetails().isEmpty()) {
                for (JasmineEventNotificationDetail entry : event.getDetails()) {
                    result = result + "\n\t" + entry.getLabel() + ":  " + entry.getMessage();
                }
            }
        } else {
            throw new IllegalArgumentException("Unable to transform this source type: " + src.getClass().getName());
        }
        result = result + "\n\t\t";
        result = result + "\n";
        return result;
    }
}

