/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.rules;

import java.io.File;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.drools.KnowledgeBase;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderConfiguration;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.conf.DumpDirOption;
import org.drools.builder.conf.KnowledgeBuilderOption;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.rule.FactHandle;
import org.ow2.jasmine.rules.api.DroolsWorkingMemoryState;
import org.ow2.jasmine.rules.api.IDroolsWorkingMemory;

public abstract class AbstractDroolsWorkingMemory
implements IDroolsWorkingMemory {
    private static Logger logger = null;
    protected Thread thread = null;
    protected volatile StatefulKnowledgeSession knowledgeSession = null;
    protected ClassLoader classLoader;
    protected KnowledgeBase knowledgeBase;
    protected volatile DroolsWorkingMemoryState state;
    protected KnowledgeBuilderConfiguration knowledgeBuilderConf;

    protected AbstractDroolsWorkingMemory(Logger logger) {
        AbstractDroolsWorkingMemory.logger = logger;
        this.state = DroolsWorkingMemoryState.IDLE;
    }

    protected void initKnowledgeBuilderConfiguration(ClassLoader classLoader) {
        Properties props = new Properties();
        props.setProperty("drools.dialect.java.compiler", "JANINO");
        this.knowledgeBuilderConf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration((Properties)props, (ClassLoader)classLoader);
        if (Boolean.getBoolean("jonas.developer")) {
            File dumpDir = new File(System.getProperty("java.io.tmpdir") + File.separator + "drools_dump");
            boolean exists = dumpDir.exists();
            if (!exists) {
                exists = dumpDir.mkdir();
            }
            if (exists && dumpDir.isDirectory()) {
                this.knowledgeBuilderConf.setOption((KnowledgeBuilderOption)DumpDirOption.get((File)dumpDir));
            }
        }
    }

    public void stop() {
        this.stop(DroolsWorkingMemoryState.STOPPED);
    }

    public void stop(DroolsWorkingMemoryState state) {
        if (this.knowledgeSession != null) {
            this.knowledgeSession.halt();
        }
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
        this.knowledgeSession = null;
        this.state = state == DroolsWorkingMemoryState.IDLE || state == DroolsWorkingMemoryState.STOPPED ? state : DroolsWorkingMemoryState.STOPPED;
    }

    public FactHandle insert(Object fact) {
        if (this.state != DroolsWorkingMemoryState.STOPPED && this.knowledgeSession != null) {
            return this.knowledgeSession.insert(fact);
        }
        return null;
    }

    protected void createWorkingMemory() {
        logger.log(Level.FINE, "Init the knowledge session...");
        this.knowledgeSession = this.knowledgeBase.newStatefulKnowledgeSession();
    }

    protected void startRuleExecutor() {
        this.state = DroolsWorkingMemoryState.RUNNING;
        this.thread = new Thread(new RuleExecutor());
        this.thread.start();
    }

    public KnowledgeBase getKnowledgeBase() {
        return this.knowledgeBase;
    }

    public DroolsWorkingMemoryState getState() {
        return this.state;
    }

    public KnowledgeBuilder newKnowledgeBuilder() {
        return KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)this.knowledgeBuilderConf);
    }

    private class RuleExecutor
    implements Runnable {
        private RuleExecutor() {
        }

        public void run() {
            AbstractDroolsWorkingMemory.this.knowledgeSession.fireUntilHalt();
        }
    }
}

